/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ProfileEx
implements Profile {
    @NotNull
    public String myName;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.profile.ProfileEx");
    public boolean myLocal;
    protected ProfileManager myProfileManager;
    @NonNls
    public static final String SCOPE = "scope";
    public static final String NAME = "name";

    public ProfileEx(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/ProfileEx", "<init>"));
        }
        this.myLocal = true;
        this.setName(name);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/ProfileEx", "getName"));
        }
        return string;
    }

    public void copyFrom(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/ProfileEx", "copyFrom"));
        }
        try {
            Element config = new Element("config");
            profile.writeExternal(config);
            this.readExternal(config);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setLocal(boolean isLocal) {
        this.myLocal = isLocal;
    }

    public boolean isLocal() {
        return this.myLocal;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/profile/ProfileEx", "setName"));
        }
        this.myName = name;
    }

    public void setProfileManager(@NotNull ProfileManager profileManager) {
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/ProfileEx", "setProfileManager"));
        }
        this.myProfileManager = profileManager;
    }

    @NotNull
    public ProfileManager getProfileManager() {
        ProfileManager profileManager = this.myProfileManager;
        if (profileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/ProfileEx", "getProfileManager"));
        }
        return profileManager;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public void profileChanged() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileEx)) {
            return false;
        }
        ProfileEx profileEx = (ProfileEx)o;
        return this.myName.equals(profileEx.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public int compareTo(Object o) {
        if (o instanceof Profile) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
        return 0;
    }

    public void convert(@NotNull Element element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/profile/ProfileEx", "convert"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/ProfileEx", "convert"));
        }
    }
}

