/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.LocationNameFieldsBinding;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewDirectoryProjectDialog
extends DialogWrapper {
    private JTextField myProjectNameTextField;
    private TextFieldWithBrowseButton myLocationField;
    protected JPanel myRootPane;
    protected JComboBox myProjectTypeComboBox;
    private JPanel myProjectTypePanel;
    private JLabel myLocationLabel;
    private JPanel myPlaceHolder;
    private static final Object EMPTY_PROJECT_GENERATOR = new Object();
    private final DirectoryProjectGenerator myGeneratorBeforeSeparator;

    protected JPanel getPlaceHolder() {
        return this.myPlaceHolder;
    }

    protected NewDirectoryProjectDialog(Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle("Create New Project");
        this.init();
        this.myLocationLabel.setLabelFor(this.myLocationField.getChildComponent());
        new LocationNameFieldsBinding(project, this.myLocationField, this.myProjectNameTextField, ProjectUtil.getBaseDir(), "Select Location for Project Directory");
        DirectoryProjectGenerator[] generators = this.getGenerators();
        if (generators.length == 0) {
            this.myProjectTypePanel.setVisible(false);
            this.myGeneratorBeforeSeparator = null;
        } else {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
            model.addElement(this.getEmptyProjectGenerator());
            ArrayList primaryGenerators = ContainerUtil.newArrayList();
            ArrayList otherGenerators = ContainerUtil.newArrayList();
            for (DirectoryProjectGenerator generator : generators) {
                if (generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)((Object)generator)).isHidden()) continue;
                boolean primary = true;
                if (generator instanceof WebProjectGenerator) {
                    primary = ((WebProjectGenerator)generator).isPrimaryGenerator();
                }
                if (primary) {
                    primaryGenerators.add(generator);
                    continue;
                }
                otherGenerators.add(generator);
            }
            this.myGeneratorBeforeSeparator = !primaryGenerators.isEmpty() && !otherGenerators.isEmpty() ? (DirectoryProjectGenerator)primaryGenerators.get(primaryGenerators.size() - 1) : null;
            for (DirectoryProjectGenerator generator : primaryGenerators) {
                model.addElement(generator);
            }
            for (DirectoryProjectGenerator generator : otherGenerators) {
                model.addElement(generator);
            }
            this.myProjectTypeComboBox.setModel(model);
            this.myProjectTypeComboBox.setRenderer(this.createProjectTypeListCellRenderer(this.myProjectTypeComboBox.getRenderer()));
        }
        this.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
            }

            public void validate() {
                NewDirectoryProjectDialog.this.checkValid();
            }
        });
    }

    @NotNull
    private ListCellRenderer createProjectTypeListCellRenderer(final @NotNull ListCellRenderer originalRenderer) {
        if (originalRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalRenderer", "com/intellij/platform/NewDirectoryProjectDialog", "createProjectTypeListCellRenderer"));
        }
        ListCellRenderer intermediate = this.myGeneratorBeforeSeparator == null ? originalRenderer : new ListCellRenderer(){
            private final JSeparator mySeparator = new JSeparator(0);
            private final JPanel myComponentWithSeparator = new JPanel(new BorderLayout(0, 0));

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component original = originalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index != -1 && value == NewDirectoryProjectDialog.this.myGeneratorBeforeSeparator && value instanceof DirectoryProjectGenerator && original instanceof JLabel) {
                    this.myComponentWithSeparator.removeAll();
                    JLabel label = (JLabel)original;
                    label.setText(((DirectoryProjectGenerator)value).getName());
                    this.myComponentWithSeparator.add((Component)label, "Center");
                    this.myComponentWithSeparator.add((Component)this.mySeparator, "South");
                    this.myComponentWithSeparator.revalidate();
                    this.myComponentWithSeparator.repaint();
                    return this.myComponentWithSeparator;
                }
                return original;
            }
        };
        ListCellRendererWrapper listCellRendererWrapper = new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
                if (value == null) {
                    return;
                }
                if (value == EMPTY_PROJECT_GENERATOR) {
                    this.setText("Empty project");
                } else {
                    this.setText(((DirectoryProjectGenerator)value).getName());
                }
            }
        };
        if (listCellRendererWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/NewDirectoryProjectDialog", "createProjectTypeListCellRenderer"));
        }
        return listCellRendererWrapper;
    }

    protected Object getEmptyProjectGenerator() {
        return EMPTY_PROJECT_GENERATOR;
    }

    protected DirectoryProjectGenerator[] getGenerators() {
        return (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
    }

    protected void checkValid() {
        String baseDirPath;
        ValidationResult validationResult;
        String projectName = this.myProjectNameTextField.getText();
        if (projectName.trim().isEmpty()) {
            this.setOKActionEnabled(false);
            this.setErrorText("Project name can't be empty");
            return;
        }
        if (this.myLocationField.getText().indexOf(36) >= 0) {
            this.setOKActionEnabled(false);
            this.setErrorText("Project directory name must not contain the $ character");
            return;
        }
        DirectoryProjectGenerator generator = this.getProjectGenerator();
        if (generator != null && !(validationResult = generator.validate(baseDirPath = this.myLocationField.getTextField().getText())).isOk()) {
            this.setOKActionEnabled(false);
            this.setErrorText(validationResult.getErrorMessage());
            return;
        }
        this.setOKActionEnabled(true);
        this.setErrorText(null);
    }

    private void registerValidators(FacetValidatorsManager validatorsManager) {
        NewDirectoryProjectDialog.validateOnTextChange(validatorsManager, this.myLocationField.getTextField());
        NewDirectoryProjectDialog.validateOnSelectionChange(validatorsManager, this.myProjectTypeComboBox);
    }

    private static void validateOnSelectionChange(final FacetValidatorsManager validatorsManager, JComboBox projectNameTextField) {
        projectNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                validatorsManager.validate();
            }
        });
    }

    private static void validateOnTextChange(final FacetValidatorsManager validatorsManager, JTextField textField) {
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                validatorsManager.validate();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myRootPane;
    }

    public String getNewProjectLocation() {
        return this.myLocationField.getText();
    }

    public String getNewProjectName() {
        return this.myProjectNameTextField.getText();
    }

    @Nullable
    public DirectoryProjectGenerator getProjectGenerator() {
        Object selItem = this.myProjectTypeComboBox.getSelectedItem();
        if (selItem == EMPTY_PROJECT_GENERATOR) {
            return null;
        }
        return (DirectoryProjectGenerator)selItem;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectNameTextField;
    }

    protected String getHelpId() {
        return "create_new_project_dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel3;
        this.myRootPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Project name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationLabel = jLabel = new JLabel();
        jLabel.setText("Location:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProjectNameTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(450, -1), null));
        this.myLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        this.myProjectTypePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Project type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectTypeComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

