/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DependencyValidationManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/scopes/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=ScopesStateSplitter.class)})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packageDependencies.DependencyValidationManagerImpl");
    private static final NotNullLazyValue<Icon> ourSharedScopeIcon = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared});
            if (layeredIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$1", "compute"));
            }
            return layeredIcon;
        }
    };
    private final List<DependencyRule> myRules = new ArrayList<DependencyRule>();
    private final NamedScopeManager myNamedScopeManager;
    public boolean SKIP_IMPORT_STATEMENTS = false;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final Map<String, PackageSet> myUnnamedScopes = new HashMap<String, PackageSet>();
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopes = ContainerUtil.createLockFreeCopyOnWriteList();

    public DependencyValidationManagerImpl(Project project, NamedScopeManager namedScopeManager) {
        super(project);
        this.myNamedScopeManager = namedScopeManager;
        namedScopeManager.addScopeListener(new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                DependencyValidationManagerImpl.this.reloadScopes();
            }
        });
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        CustomScopesProvider[] scopesProviders;
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            predefinedScopes.addAll(scopesProvider.getCustomScopes());
        }
        ArrayList<NamedScope> arrayList = predefinedScopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScopes"));
        }
        return arrayList;
    }

    public NamedScope getPredefinedScope(@NotNull String name) {
        CustomScopesProvider[] scopesProviders;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getPredefinedScope"));
        }
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            NamedScope scope;
            NamedScope namedScope = scope = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope((String)name, (List)scopesProvider.getCustomScopes());
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public boolean hasRules() {
        return !this.myRules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRule"));
        }
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @NotNull
    public DependencyRule[] getViolatorDependencyRules(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getViolatorDependencyRules"));
        }
        return dependencyRuleArray;
    }

    @NotNull
    public DependencyRule[] getApplicableRules(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        ArrayList<DependencyRule> result = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myRules) {
            if (!dependencyRule.isApplicable(file)) continue;
            result.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result.toArray(new DependencyRule[result.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getApplicableRules"));
        }
        return dependencyRuleArray;
    }

    public boolean skipImportStatements() {
        return this.SKIP_IMPORT_STATEMENTS;
    }

    public void setSkipImportStatements(boolean skip) {
        this.SKIP_IMPORT_STATEMENTS = skip;
    }

    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        Map<String, PackageSet> map = this.myUnnamedScopes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getUnnamedScopes"));
        }
        return map;
    }

    @NotNull
    public DependencyRule[] getAllRules() {
        DependencyRule[] dependencyRuleArray = this.myRules.toArray(new DependencyRule[this.myRules.size()]);
        if (dependencyRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getAllRules"));
        }
        return dependencyRuleArray;
    }

    public void removeAllRules() {
        this.myRules.clear();
    }

    public void addRule(@NotNull DependencyRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addRule"));
        }
        this.appendUnnamedScope(rule.getFromScope());
        this.appendUnnamedScope(rule.getToScope());
        this.myRules.add(rule);
    }

    public void reloadRules() {
        Element element = new Element("rules_2_reload");
        this.writeRules(element);
        this.readRules(element);
    }

    private void appendUnnamedScope(NamedScope fromScope) {
        PackageSet packageSet;
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !this.myUnnamedScopes.containsKey(packageSet.getText())) {
            this.myUnnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return (Icon)ourSharedScopeIcon.getValue();
    }

    public void loadState(Element element) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
        }
        super.loadState(element);
        this.myUnnamedScopes.clear();
        List unnamedScopes = element.getChildren(UNNAMED_SCOPE);
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Object unnamedScope : unnamedScopes) {
            try {
                String packageSet = ((Element)unnamedScope).getAttributeValue(VALUE);
                this.myUnnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException e) {}
        }
        this.readRules(element);
    }

    private void readRules(Element element) {
        this.removeAllRules();
        List rules = element.getChildren(DENY_RULE_KEY);
        for (Object rule1 : rules) {
            DependencyRule rule = this.readRule((Element)rule1);
            if (rule == null) continue;
            this.addRule(rule);
        }
    }

    public Element getState() {
        Element element = super.getState();
        try {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
        ArrayList<String> unnamedScopes = new ArrayList<String>(this.myUnnamedScopes.keySet());
        Collections.sort(unnamedScopes);
        for (String unnamedScope : unnamedScopes) {
            Element unnamedElement = new Element(UNNAMED_SCOPE);
            unnamedElement.setAttribute(VALUE, unnamedScope);
            element.addContent(unnamedElement);
        }
        this.writeRules(element);
        return element;
    }

    private void writeRules(Element element) {
        for (DependencyRule rule : this.myRules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        PackageSet packageSet;
        NamedScope scope = super.getScope(name);
        if (scope == null && (packageSet = this.myUnnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(Element ruleElement) {
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DependencyValidationManagerImpl.this.getProject().isDisposed()) {
                    return;
                }
                ArrayList scopeList = new ArrayList();
                DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)DependencyValidationManagerImpl.this);
                DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)DependencyValidationManagerImpl.this.myNamedScopeManager);
                DependencyValidationManagerImpl.this.myScopes.clear();
                DependencyValidationManagerImpl.this.myScopes.addAll(scopeList);
                DependencyValidationManagerImpl.this.reloadRules();
            }
        });
    }

    private static void addScopesToList(@NotNull List<Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        NamedScope[] scopes;
        if (scopeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeList", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "addScopesToList"));
        }
        for (NamedScope scope : scopes = holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list = this.myScopes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl", "getScopeBasedHighlightingCachedScopes"));
        }
        return list;
    }

    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    public static class ScopesStateSplitter
    implements StateSplitter {
        public List<Pair<Element, String>> splitState(Element e) {
            Element[] elements;
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            for (Element element : elements = JDOMUtil.getElements((Element)e)) {
                if (!element.getName().equals("scope")) continue;
                element.detach();
                String scopeName = element.getAttributeValue("name");
                assert (scopeName != null);
                String name = generator.generateUniqueName(FileUtil.sanitizeFileName((String)scopeName)) + ".xml";
                result.add((Pair<Element, String>)Pair.create((Object)element, (Object)name));
            }
            if (!e.getChildren().isEmpty()) {
                result.add((Pair<Element, String>)Pair.create((Object)e, (Object)(generator.generateUniqueName("scope_settings") + ".xml")));
            }
            return result;
        }

        public void mergeStatesInto(Element target, Element[] elements) {
            for (Element element : elements) {
                Element[] states;
                if (element.getName().equals("scope")) {
                    element.detach();
                    target.addContent(element);
                    continue;
                }
                for (Element state2 : states = JDOMUtil.getElements((Element)element)) {
                    state2.detach();
                    target.addContent(state2);
                }
                for (Attribute attr : element.getAttributes()) {
                    target.setAttribute(attr.clone());
                }
            }
        }
    }
}

