/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleReadOnlyAttributePanel
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private StatusBar myStatusBar;

    @NotNull
    public Icon getIcon() {
        Project project = this.getProject();
        VirtualFile virtualFile = null;
        if (project != null) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            VirtualFile[] selectedFiles = editorManager.getSelectedFiles();
            virtualFile = selectedFiles.length > 0 ? selectedFiles[0] : null;
        }
        Icon icon = virtualFile == null || virtualFile.isWritable() ? AllIcons.Ide.Readwrite : AllIcons.Ide.Readonly;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String ID() {
        if ("ReadOnlyAttribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "ID"));
        }
        return "ReadOnlyAttribute";
    }

    public StatusBarWidget copy() {
        return new ToggleReadOnlyAttributePanel();
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "getPresentation"));
        }
        return this;
    }

    public void dispose() {
        this.myStatusBar = null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "install"));
        }
        this.myStatusBar = statusBar;
    }

    public String getTooltipText() {
        return this.isReadonlyApplicable() ? UIBundle.message((String)"read.only.attr.panel.double.click.to.toggle.attr.tooltip.text", (Object[])new Object[0]) : null;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                final Project project = ToggleReadOnlyAttributePanel.this.getProject();
                if (project == null) {
                    return;
                }
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                final VirtualFile[] files = editorManager.getSelectedFiles();
                if (!ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFiles(files)) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)files[0], (boolean)files[0].isWritable());
                            ToggleReadOnlyAttributePanel.this.myStatusBar.updateWidget(ToggleReadOnlyAttributePanel.this.ID());
                        }
                        catch (IOException e) {
                            Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                        }
                    }
                });
            }
        };
    }

    private boolean isReadonlyApplicable() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return false;
        }
        VirtualFile[] selectedFiles = editorManager.getSelectedFiles();
        return ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFiles(selectedFiles);
    }

    private static boolean isReadOnlyApplicableForFiles(VirtualFile[] files) {
        return files.length > 0 && !files[0].getFileSystem().isReadOnly();
    }

    @Nullable
    private Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((JComponent)this.myStatusBar)));
    }
}

