/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class TextPanel
extends JComponent {
    @Nullable
    private String myText;
    @Nullable
    private Color myCustomColor;
    private Integer myPrefHeight;
    private Dimension myExplicitSize;
    private boolean myDecorate = true;
    private float myAlignment;
    private int myRightPadding = 20;

    protected TextPanel() {
        this.setOpaque(false);
    }

    @Override
    public Font getFont() {
        return SystemInfo.isMac ? UIUtil.getLabelFont().deriveFont(11.0f) : UIUtil.getLabelFont();
    }

    protected TextPanel(boolean decorate) {
        this();
        this.myDecorate = decorate;
    }

    public void recomputeSize() {
        JLabel label = new JLabel("XXX");
        label.setFont(this.getFont());
        this.myPrefHeight = label.getPreferredSize().height;
    }

    public void setDecorate(boolean decorate) {
        this.myDecorate = decorate;
    }

    public void resetColor() {
        this.myCustomColor = null;
    }

    public void setCustomColor(@Nullable Color customColor) {
        this.myCustomColor = customColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String s = this.getText();
        Rectangle bounds = this.getBounds();
        if (UIUtil.isUnderDarcula()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (s == null) {
            return;
        }
        Insets insets = this.getInsets();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        UIUtil.applyRenderingHints((Graphics)g2);
        FontMetrics fm = g2.getFontMetrics();
        int sWidth = fm.stringWidth(s);
        int x = insets.left;
        if (this.myAlignment == 0.5f || this.myAlignment == 1.0f) {
            x = this.myAlignment == 0.5f ? (bounds.width - sWidth) / 2 : bounds.width - insets.right - sWidth;
        }
        Rectangle textR = new Rectangle();
        Rectangle iconR = new Rectangle();
        Rectangle viewR = new Rectangle(bounds);
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.width -= insets.left;
        viewR.width -= insets.right;
        int maxWidth = bounds.width - insets.left - insets.right;
        if (sWidth > maxWidth) {
            s = this.truncateText(s, bounds, fm, textR, iconR, maxWidth);
        }
        int y = UIUtil.getStringY((String)s, (Rectangle)bounds, (Graphics2D)g2);
        if (SystemInfo.isMac && !UIUtil.isUnderDarcula() && this.myDecorate) {
            g2.setColor((Color)(this.myCustomColor == null ? Gray._215 : this.myCustomColor));
            g2.drawString(s, x, y + 1);
        }
        g2.setColor(this.myCustomColor == null ? this.getForeground() : this.myCustomColor);
        g2.drawString(s, x, y);
    }

    protected String truncateText(String text, Rectangle bounds, FontMetrics fm, Rectangle textR, Rectangle iconR, int maxWidth) {
        return SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 0, 0, 11, bounds, iconR, textR, 0);
    }

    public void setTextAlignment(float alignment) {
        this.myAlignment = alignment;
    }

    private static String splitText(JLabel label, String text, int widthLimit) {
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        String[] lines = UIUtil.splitText((String)text, (FontMetrics)fontMetrics, (int)widthLimit, (char)' ');
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                result.append('\n');
            }
            result.append(line);
        }
        return result.toString();
    }

    public final void setText(@Nullable String text) {
        if ((text = StringUtil.notNullize((String)text)).equals(this.myText)) {
            return;
        }
        this.myText = text;
        this.setPreferredSize(this.getPanelDimensionFromFontMetrics(this.myText));
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myExplicitSize != null) {
            return this.myExplicitSize;
        }
        String text = this.getTextForPreferredSize();
        return this.getPanelDimensionFromFontMetrics(text);
    }

    public void setRightPadding(int rightPadding) {
        this.myRightPadding = rightPadding;
    }

    private Dimension getPanelDimensionFromFontMetrics(String text) {
        int width = text == null ? 0 : this.myRightPadding + this.getFontMetrics(this.getFont()).stringWidth(text);
        int height = this.myPrefHeight == null ? this.getMinimumSize().height : this.myPrefHeight;
        return new Dimension(width, height);
    }

    @Nullable
    protected String getTextForPreferredSize() {
        return this.myText;
    }

    public void setExplicitSize(@Nullable Dimension explicitSize) {
        this.myExplicitSize = explicitSize;
    }
}

