/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.status.StatusBarUI;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MacStatusBarUI
extends StatusBarUI
implements Activatable {
    private static final Border BACKGROUND_PAINTER = new MacBackgroundPainter();
    private JComponent myComponent;
    private WindowAdapter myWindowListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MacStatusBarUI.this.myComponent != null) {
                        MacStatusBarUI.this.myComponent.repaint();
                    }
                }
            });
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MacStatusBarUI.this.myComponent != null) {
                        MacStatusBarUI.this.myComponent.repaint();
                    }
                }
            });
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MacStatusBarUI.this.myComponent != null) {
                        MacStatusBarUI.this.myComponent.repaint();
                    }
                }
            });
        }
    };

    public static boolean isActive(Component c) {
        Window ancestor = SwingUtilities.getWindowAncestor(c);
        return ancestor != null && ancestor.isActive();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.myComponent = c;
        new UiNotifyConnector((Component)c, (Activatable)this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.myComponent = null;
    }

    public void showNotify() {
        if (this.myComponent != null && SystemInfo.isMac) {
            Window window = SwingUtilities.getWindowAncestor(this.myComponent);
            window.addWindowListener(this.myWindowListener);
            window.addWindowFocusListener(this.myWindowListener);
        }
    }

    public void hideNotify() {
        Window window;
        if (this.myComponent != null && SystemInfo.isMac && (window = SwingUtilities.getWindowAncestor(this.myComponent)) != null) {
            window.removeWindowListener(this.myWindowListener);
            window.removeWindowFocusListener(this.myWindowListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle bounds = c.getBounds();
        BACKGROUND_PAINTER.paintBorder(c, g, 0, 0, bounds.width, bounds.height);
    }

    private static final class MacBackgroundPainter
    implements Border {
        private static final Color ACTIVE_TOP_COLOR = Gray._202;
        private static final Color ACTIVE_BOTTOM_COLOR = Gray._167;
        private static final Color INACTIVE_TOP_COLOR = new Color(0xE3E3E3);
        private static final Color INACTIVE_BOTTOM_COLOR = new Color(0xCFCFCF);
        private static final Color ACTIVE_BORDER_TOP_COLOR = Gray._81;
        private static final Color ACTIVE_BORDER2_TOP_COLOR = Gray._227;
        private static final Color INACTIVE_BORDER_TOP_COLOR = Gray._153;
        private static final Color INACTIVE_BORDER2_TOP_COLOR = Gray._251;
        private static final Insets INSETS = new Insets(0, 0, 0, 0);
        private BufferedImage[] myCache = new BufferedImage[2];

        private MacBackgroundPainter() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle r = g2d.getClipBounds();
            Image img = this.getCachedImage(c, g2d);
            int step = img.getWidth(null);
            for (int i = r.x; i < r.x + r.width; i += step) {
                UIUtil.drawImage((Graphics)g2d, (Image)img, (int)i, (int)y, null);
            }
        }

        private Image getCachedImage(Component c, Graphics2D g2d) {
            boolean active = MacStatusBarUI.isActive(c);
            int ndx = active ? 0 : 1;
            BufferedImage image = this.myCache[ndx];
            if (image == null || image.getHeight(null) != c.getHeight()) {
                int width = 50;
                int height = c.getHeight();
                image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                Color top = active ? ACTIVE_TOP_COLOR : INACTIVE_TOP_COLOR;
                Color bottom = active ? ACTIVE_BOTTOM_COLOR : INACTIVE_BOTTOM_COLOR;
                Paint paint = UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)top, (float)0.0f, (float)height, (Color)bottom);
                g.setPaint(paint);
                g.fillRect(0, 0, width, height);
                if (active) {
                    g.setColor(ACTIVE_BORDER_TOP_COLOR);
                    g.drawLine(0, 0, width, 0);
                    g.setColor(ACTIVE_BORDER2_TOP_COLOR);
                    g.drawLine(0, 1, width, 1);
                } else {
                    g.setColor(INACTIVE_BORDER_TOP_COLOR);
                    g.drawLine(0, 0, width, 0);
                    g.setColor(INACTIVE_BORDER2_TOP_COLOR);
                    g.drawLine(0, 1, width, 1);
                }
                this.myCache[ndx] = image;
            }
            return image;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

