/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowFactoryEx;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowImpl
implements ToolWindowEx {
    private final PropertyChangeSupport myChangeSupport;
    private final ToolWindowManagerImpl myToolWindowManager;
    private final String myId;
    private final JComponent myComponent;
    private boolean myAvailable;
    private final ContentManager myContentManager;
    private Icon myIcon;
    private String myStripeTitle;
    private static final Content EMPTY_CONTENT = new ContentImpl(new JLabel(), "", false);
    private final ToolWindowContentUi myContentUI;
    private InternalDecorator myDecorator;
    private boolean myHideOnEmptyContent = false;
    private boolean myPlaceholderMode;
    private ToolWindowFactory myContentFactory;
    @NotNull
    private ActionCallback myActivation = new ActionCallback.Done();
    private final BusyObject.Impl myShowing = new BusyObject.Impl(){

        public boolean isReady() {
            return ToolWindowImpl.this.myComponent != null && ToolWindowImpl.this.myComponent.isShowing();
        }
    };
    private boolean myUseLastFocused = true;
    private static final Logger LOG = Logger.getInstance(ToolWindowImpl.class);

    ToolWindowImpl(ToolWindowManagerImpl toolWindowManager, String id, boolean canCloseContent, @Nullable JComponent component) {
        this.myToolWindowManager = toolWindowManager;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myId = id;
        this.myAvailable = true;
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        this.myContentUI = new ToolWindowContentUi(this);
        this.myContentManager = contentFactory.createContentManager((ContentUI)this.myContentUI, canCloseContent, toolWindowManager.getProject());
        if (component != null) {
            Content content = contentFactory.createContent(component, "", false);
            this.myContentManager.addContent(content);
            this.myContentManager.setSelectedContent(content, false);
        }
        this.myComponent = this.myContentManager.getComponent();
        UiNotifyConnector notifyConnector = new UiNotifyConnector((Component)this.myComponent, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                ToolWindowImpl.this.myShowing.onReady();
            }
        });
        Disposer.register((Disposable)this.myContentManager, (Disposable)notifyConnector);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public final void activate(Runnable runnable) {
        this.activate(runnable, true);
    }

    public void activate(@Nullable Runnable runnable, boolean autoFocusContents) {
        this.activate(runnable, autoFocusContents, true);
    }

    public void activate(final @Nullable Runnable runnable, boolean autoFocusContents, boolean forced) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        UiActivity.Focus activity = new UiActivity.Focus(new String[]{"toolWindow:" + this.myId});
        UiActivityMonitor.getInstance().addActivity(this.myToolWindowManager.getProject(), (UiActivity)activity, ModalityState.NON_MODAL);
        this.myToolWindowManager.activateToolWindow(this.myId, forced, autoFocusContents);
        this.getActivation().doWhenDone(new Runnable((UiActivity)activity){
            final /* synthetic */ UiActivity val$activity;
            {
                this.val$activity = uiActivity;
            }

            @Override
            public void run() {
                ToolWindowImpl.this.myToolWindowManager.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (runnable != null) {
                            runnable.run();
                        }
                        UiActivityMonitor.getInstance().removeActivity(ToolWindowImpl.this.myToolWindowManager.getProject(), val$activity);
                    }
                });
            }
        });
    }

    public final boolean isActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myToolWindowManager.isEditorComponentActive()) {
            return false;
        }
        return this.myToolWindowManager.isToolWindowActive(this.myId) || this.myDecorator != null && this.myDecorator.isFocused();
    }

    @NotNull
    public ActionCallback getReady(final @NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/wm/impl/ToolWindowImpl", "getReady"));
        }
        final ActionCallback result = new ActionCallback();
        this.myShowing.getReady((Object)this).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ArrayList<FinalizableCommand> cmd = new ArrayList<FinalizableCommand>();
                cmd.add(new FinalizableCommand(null){

                    @Override
                    public void run() {
                        IdeFocusManager.getInstance((Project)ToolWindowImpl.this.myToolWindowManager.getProject()).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                if (ToolWindowImpl.this.myContentManager.isDisposed()) {
                                    return;
                                }
                                ToolWindowImpl.this.myContentManager.getReady(requestor).notify(result);
                            }
                        });
                    }
                });
                ToolWindowImpl.this.myToolWindowManager.execute(cmd);
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowImpl", "getReady"));
        }
        return actionCallback;
    }

    public final void show(final Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.showToolWindow(this.myId);
        if (runnable != null) {
            this.getActivation().doWhenDone(new Runnable(){

                @Override
                public void run() {
                    ToolWindowImpl.this.myToolWindowManager.invokeLater(runnable);
                }
            });
        }
    }

    public final void hide(@Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.hideToolWindow(this.myId, false);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public final boolean isVisible() {
        return this.myToolWindowManager.isToolWindowVisible(this.myId);
    }

    public final ToolWindowAnchor getAnchor() {
        return this.myToolWindowManager.getToolWindowAnchor(this.myId);
    }

    public final void setAnchor(ToolWindowAnchor anchor, @Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowAnchor(this.myId, anchor);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public boolean isSplitMode() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isSplitMode(this.myId);
    }

    public void setContentUiType(ToolWindowContentUiType type, @Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setContentUiType(this.myId, type);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowImpl", "setDefaultContentUiType"));
        }
        this.myToolWindowManager.setDefaultContentUiType(this, type);
    }

    public ToolWindowContentUiType getContentUiType() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getContentUiType(this.myId);
    }

    public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setSideTool(this.myId, isSideTool);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public final void setAutoHide(boolean state2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowAutoHide(this.myId, state2);
    }

    public final boolean isAutoHide() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.isToolWindowAutoHide(this.myId);
    }

    public final ToolWindowType getType() {
        return this.myToolWindowManager.getToolWindowType(this.myId);
    }

    public final void setType(ToolWindowType type, @Nullable Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myToolWindowManager.setToolWindowType(this.myId, type);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    @Override
    public final ToolWindowType getInternalType() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myToolWindowManager.getToolWindowInternalType(this.myId);
    }

    @Override
    public void stretchWidth(int value) {
        this.myToolWindowManager.stretchWidth(this, value);
    }

    @Override
    public void stretchHeight(int value) {
        this.myToolWindowManager.stretchHeight(this, value);
    }

    @Override
    public InternalDecorator getDecorator() {
        return this.myDecorator;
    }

    @Override
    public void setAdditionalGearActions(ActionGroup additionalGearActions) {
        this.getDecorator().setAdditionalGearActions(additionalGearActions);
    }

    @Override
    public void setTitleActions(AnAction ... actions) {
        this.getDecorator().setTitleActions(actions);
    }

    public final void setAvailable(boolean available, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Boolean oldAvailable = this.myAvailable ? Boolean.TRUE : Boolean.FALSE;
        this.myAvailable = available;
        this.myChangeSupport.firePropertyChange("available", oldAvailable, this.myAvailable ? Boolean.TRUE : Boolean.FALSE);
        if (runnable != null) {
            this.myToolWindowManager.invokeLater(runnable);
        }
    }

    public void installWatcher(ContentManager contentManager) {
        new ContentManagerWatcher(this, contentManager);
    }

    public final boolean isAvailable() {
        return this.myAvailable && this.myComponent != null;
    }

    public final JComponent getComponent() {
        return this.myComponent;
    }

    public ContentManager getContentManager() {
        return this.myContentManager;
    }

    public ToolWindowContentUi getContentUI() {
        return this.myContentUI;
    }

    public final Icon getIcon() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myIcon;
    }

    public final String getId() {
        return this.myId;
    }

    public final String getTitle() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSelectedContent().getDisplayName();
    }

    @NotNull
    public final String getStripeTitle() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = (String)ObjectUtils.notNull((Object)this.myStripeTitle, (Object)this.myId);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowImpl", "getStripeTitle"));
        }
        return string;
    }

    public final void setIcon(Icon icon) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Icon oldIcon = this.getIcon();
        if (!(oldIcon == icon || icon instanceof LayeredIcon || icon.getIconHeight() == 13 && icon.getIconWidth() == 13)) {
            LOG.warn("ToolWindow icons should be 13x13. Please fix ToolWindow (ID:  " + this.getId() + ") or icon " + icon);
        }
        this.getSelectedContent().setIcon(icon);
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange("icon", oldIcon, icon);
    }

    public final void setTitle(String title) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String oldTitle = this.getTitle();
        this.getSelectedContent().setDisplayName(title);
        this.myChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    public final void setStripeTitle(@NotNull String stripeTitle) {
        if (stripeTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stripeTitle", "com/intellij/openapi/wm/impl/ToolWindowImpl", "setStripeTitle"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String oldTitle = this.myStripeTitle;
        this.myStripeTitle = stripeTitle;
        this.myChangeSupport.firePropertyChange("stripe-title", oldTitle, stripeTitle);
    }

    private Content getSelectedContent() {
        Content selected = this.getContentManager().getSelectedContent();
        return selected != null ? selected : EMPTY_CONTENT;
    }

    public void setDecorator(InternalDecorator decorator) {
        this.myDecorator = decorator;
    }

    public void fireActivated() {
        if (this.myDecorator != null) {
            this.myDecorator.fireActivated();
        }
    }

    public void fireHidden() {
        if (this.myDecorator != null) {
            this.myDecorator.fireHidden();
        }
    }

    public void fireHiddenSide() {
        if (this.myDecorator != null) {
            this.myDecorator.fireHiddenSide();
        }
    }

    public ToolWindowManagerImpl getToolWindowManager() {
        return this.myToolWindowManager;
    }

    @Nullable
    public ActionGroup getPopupGroup() {
        return this.myDecorator != null ? this.myDecorator.createPopupGroup() : null;
    }

    public void setDefaultState(@Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        this.myToolWindowManager.setDefaultState(this, anchor, type, floatingBounds);
    }

    public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        this.myHideOnEmptyContent = hideOnEmpty;
    }

    public boolean isToHideOnEmptyContent() {
        return this.myHideOnEmptyContent;
    }

    public boolean isDisposed() {
        return this.myContentManager.isDisposed();
    }

    public boolean isPlaceholderMode() {
        return this.myPlaceholderMode;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.myPlaceholderMode = placeholderMode;
    }

    @NotNull
    public ActionCallback getActivation() {
        ActionCallback actionCallback = this.myActivation;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowImpl", "getActivation"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setActivation(@NotNull ActionCallback activation) {
        if (activation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activation", "com/intellij/openapi/wm/impl/ToolWindowImpl", "setActivation"));
        }
        if (!this.myActivation.isProcessed() && !this.myActivation.equals(activation)) {
            this.myActivation.setRejected();
        }
        ActionCallback actionCallback = this.myActivation = activation;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowImpl", "setActivation"));
        }
        return actionCallback;
    }

    public void setContentFactory(ToolWindowFactory contentFactory) {
        this.myContentFactory = contentFactory;
        if (contentFactory instanceof ToolWindowFactoryEx) {
            ((ToolWindowFactoryEx)contentFactory).init((ToolWindow)this);
        }
    }

    public void ensureContentInitialized() {
        if (this.myContentFactory != null) {
            this.getContentManager().removeAllContents(false);
            this.myContentFactory.createToolWindowContent(this.myToolWindowManager.getProject(), (ToolWindow)this);
            this.myContentFactory = null;
        }
    }

    public void showContentPopup(InputEvent inputEvent) {
        this.myContentUI.toggleContentPopup();
    }

    @Override
    public void setUseLastFocusedOnActivation(boolean focus) {
        this.myUseLastFocused = focus;
    }

    @Override
    public boolean isUseLastFocusedOnActivation() {
        return this.myUseLastFocused;
    }
}

