/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Rectangle;

@State(name="ProjectFrameBounds", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ProjectFrameBounds
implements PersistentStateComponent<Rectangle> {
    private final Project myProject;
    private Rectangle myBounds;

    public static ProjectFrameBounds getInstance(Project project) {
        return (ProjectFrameBounds)ServiceManager.getService((Project)project, ProjectFrameBounds.class);
    }

    public ProjectFrameBounds(Project project) {
        this.myProject = project;
    }

    public Rectangle getState() {
        return WindowManager.getInstance().getFrame(this.myProject).getBounds();
    }

    public void loadState(Rectangle state2) {
        this.myBounds = state2;
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }
}

