/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FakeVirtualFile
extends StubVirtualFile {
    private final VirtualFile myParent;
    private final String myName;

    public FakeVirtualFile(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile", "<init>"));
        }
        this.myName = name;
        this.myParent = parent;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile = this.myParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile", "getParent"));
        }
        return virtualFile;
    }

    @NotNull
    public String getPath() {
        String basePath = this.myParent.getPath();
        String string = StringUtil.endsWithChar((CharSequence)basePath, (char)'/') ? basePath + this.myName : basePath + '/' + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile", "getPath"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/FakeVirtualFile", "getName"));
        }
        return string;
    }

    public String toString() {
        return this.getPath();
    }
}

