/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import gnu.trove.TLongObjectHashMap;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshQueueImpl
extends RefreshQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
    private final ExecutorService myQueue = ConcurrencyUtil.newSingleThreadExecutor((String)"FS Synchronizer");
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(VfsBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
    private final TLongObjectHashMap<RefreshSession> mySessions = new TLongObjectHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.ERROR);

    public void execute(@NotNull RefreshSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "execute"));
        }
        if (session.isAsynchronous()) {
            ModalityState state2 = session.getModalityState();
            this.queueSession(session, state2);
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread()) {
                this.doScan(session);
                session.fireEvents(app.isWriteAccessAllowed());
            } else {
                if (((ApplicationEx)app).holdsReadLock()) {
                    LOG.error("Do not call synchronous refresh under read lock (except from EDT) - this will cause a deadlock if there are any events to fire.");
                    return;
                }
                this.queueSession(session, ModalityState.defaultModalityState());
                session.waitFor();
            }
        }
    }

    private void queueSession(final @NotNull RefreshSessionImpl session, final @NotNull ModalityState modality) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "queueSession"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "queueSession"));
        }
        this.myQueue.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RefreshQueueImpl.this.myRefreshIndicator.start();
                    HeavyProcessLatch.INSTANCE.processStarted();
                    try {
                        RefreshQueueImpl.this.doScan(session);
                    }
                    finally {
                        HeavyProcessLatch.INSTANCE.processFinished();
                        RefreshQueueImpl.this.myRefreshIndicator.stop();
                    }
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                        public void run() {
                            session.fireEvents(false);
                        }
                    }, modality);
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */, modality);
            }
        });
        this.myEventCounter.eventHappened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScan(RefreshSessionImpl session) {
        try {
            this.updateSessionMap(session, true);
            session.scan();
        }
        finally {
            this.updateSessionMap(session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(RefreshSession session, boolean add) {
        long id = session.getId();
        if (id != 0L) {
            TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
            synchronized (tLongObjectHashMap) {
                if (add) {
                    this.mySessions.put(id, (Object)session);
                } else {
                    this.mySessions.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSession(long id) {
        RefreshSession session;
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            session = (RefreshSession)this.mySessions.get(id);
        }
        if (session instanceof RefreshSessionImpl) {
            ((RefreshSessionImpl)session).cancel();
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "createSession"));
        }
        RefreshSessionImpl refreshSessionImpl = new RefreshSessionImpl(async, recursively, finishRunnable, state2);
        if (refreshSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "createSession"));
        }
        return refreshSessionImpl;
    }

    public void processSingleEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "processSingleEvent"));
        }
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = refreshQueue.mySessions;
        synchronized (tLongObjectHashMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }
}

