/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.VcsGlobalMessage;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GlobalMessageService", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/vcs.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class VcsGlobalMessageManager
implements ProjectComponent,
PersistentStateComponent<VcsGlobalMessage> {
    private VcsGlobalMessage myState;

    public static VcsGlobalMessageManager getInstance(Project project) {
        return (VcsGlobalMessageManager)project.getComponent(VcsGlobalMessageManager.class);
    }

    @Nullable
    public VcsGlobalMessage getState() {
        return this.myState;
    }

    public void loadState(VcsGlobalMessage state2) {
        this.myState = state2 == null ? new VcsGlobalMessage() : state2;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nullable
    public JComponent getMessageBanner() {
        VcsGlobalMessage message;
        if (ApplicationManagerEx.getApplicationEx().isInternal() && (message = this.myState) != null && !StringUtil.isEmpty((String)message.message)) {
            JEditorPane text = new JEditorPane();
            text.setEditorKit(UIUtil.getHTMLEditorKit());
            text.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            });
            JLabel label = new JLabel(NotificationsUtil.buildHtml("", message.message, null));
            text.setText(NotificationsUtil.buildHtml("", message.message, "width:" + Math.min(400, label.getPreferredSize().width) + "px;"));
            text.setEditable(false);
            text.setOpaque(false);
            text.setBorder(null);
            JPanel content = new JPanel(new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
            text.setCaretPosition(0);
            JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)text, (int)20, (int)30);
            pane.setBorder(null);
            pane.setOpaque(false);
            pane.getViewport().setOpaque(false);
            content.add((Component)pane, "Center");
            NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
            north.add((Component)new JLabel(AllIcons.General.BalloonWarning), (Object)"North");
            content.add((Component)north, "West");
            content.setBorder(new EmptyBorder(8, 4, 8, 4));
            content.setBackground(MessageType.WARNING.getPopupBackground());
            return content;
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("VcsGlobalMessageManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsGlobalMessageManager", "getComponentName"));
        }
        return "VcsGlobalMessageManager";
    }
}

