/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    private final FileHistorySessionPartner mySessionPartner;
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final FilePath myPath;
    private final AbstractVcs myVcs;
    private boolean myCanUseCache;
    private boolean myIsRefresh;

    public FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, AnnotationProvider annotationProvider, FilePath path, String repositoryPath, AbstractVcs vcs) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myVcs = vcs;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, annotationProvider, path, repositoryPath, vcs, this);
        this.myCanUseCache = true;
    }

    @Override
    public void run(boolean isRefresh, boolean canUseLastRevision) {
        this.mySessionPartner.beforeRefresh();
        VcsHistoryProviderBackgroundableProxy proxy = new VcsHistoryProviderBackgroundableProxy(this.myVcs, this.myVcsHistoryProvider, this.myVcs.getDiffProvider());
        proxy.executeAppendableSession(this.myVcs.getKeyInstanceMethod(), this.myPath, this.mySessionPartner, null, this.myCanUseCache, canUseLastRevision);
        this.myCanUseCache = false;
        this.myIsRefresh = isRefresh;
    }

    @Override
    public boolean isFirstTime() {
        return !this.myIsRefresh;
    }
}

