/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.diff.Diff;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range {
    private static final Logger LOG = Logger.getInstance(Range.class);
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myLine1;
    private int myLine2;
    private final int myVcsLine1;
    private final int myVcsLine2;
    private final byte myType;
    @Nullable
    private RangeHighlighter myRangeHighlighter;
    private boolean myValid;

    public static Range createOn(@NotNull Diff.Change change, int shift, int vcsShift) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/ex/Range", "createOn"));
        }
        byte type = Range.getChangeTypeFrom(change);
        int line1 = shift + change.line1;
        int line2 = line1 + change.inserted;
        int vcsLine1 = vcsShift + change.line0;
        int vcsLine2 = vcsLine1 + change.deleted;
        return new Range(line1, line2, vcsLine1, vcsLine2, type);
    }

    private static byte getChangeTypeFrom(@NotNull Diff.Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/ex/Range", "getChangeTypeFrom"));
        }
        if (change.deleted > 0 && change.inserted > 0) {
            return 1;
        }
        if (change.deleted > 0) {
            return 3;
        }
        if (change.inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    public Range(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/Range", "<init>"));
        }
        this(range.getLine1(), range.getLine2(), range.getVcsLine1(), range.getVcsLine2(), range.getType());
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2, byte type) {
        this.myValid = true;
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myVcsLine1 = vcsLine1;
        this.myVcsLine2 = vcsLine2;
        this.myType = type;
    }

    public int hashCode() {
        return this.myVcsLine1 ^ this.myVcsLine2 ^ this.myType ^ this.myLine1 ^ this.myLine2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range other = (Range)object;
        return this.myVcsLine1 == other.myVcsLine1 && this.myVcsLine2 == other.myVcsLine2 && this.myLine1 == other.myLine1 && this.myLine2 == other.myLine2 && this.myType == other.myType;
    }

    public String toString() {
        return String.format("%s, %s, %s, %s, %s", this.myLine1, this.myLine2, this.myVcsLine1, this.myVcsLine2, this.getTypeName());
    }

    @NonNls
    private String getTypeName() {
        switch (this.myType) {
            case 1: {
                return "MODIFIED";
            }
            case 2: {
                return "INSERTED";
            }
            case 3: {
                return "DELETED";
            }
        }
        return "UNKNOWN";
    }

    public byte getType() {
        return this.myType;
    }

    public int getUpToDateRangeLength() {
        return this.myVcsLine2 - this.myVcsLine1;
    }

    public void shift(int shift) {
        this.myLine1 += shift;
        this.myLine2 += shift;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    public int getVcsLine1() {
        return this.myVcsLine1;
    }

    public int getVcsLine2() {
        return this.myVcsLine2;
    }

    public boolean rightBefore(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/Range", "rightBefore"));
        }
        return this.myLine2 == range.myLine1;
    }

    public boolean hasHighlighter() {
        return this.myRangeHighlighter != null;
    }

    public void setHighlighter(RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isSelectedByLine(int line) {
        if (this.getType() == 3 && line == this.myLine1) {
            return true;
        }
        return line >= this.myLine1 && line < this.myLine2;
    }
}

