/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerDrawing {
    private LineStatusTrackerDrawing() {
    }

    static TextAttributes getAttributesFor(Range range) {
        Color stripeColor = LineStatusTrackerDrawing.getDiffColor(range, false);
        TextAttributes textAttributes = new TextAttributes(null, stripeColor, null, EffectType.BOXED, 0);
        textAttributes.setErrorStripeColor(stripeColor);
        return textAttributes;
    }

    private static void paintGutterFragment(Editor editor, Graphics g, Rectangle r, Color stripeColor) {
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        g.setColor(stripeColor);
        int endX = gutter.getWhitespaceSeparatorOffset();
        int x = r.x + r.width - 5;
        int width = endX - x;
        if (r.height > 0) {
            g.fillRect(x, r.y, width, r.height);
            g.setColor(gutter.getOutlineColor(false));
            UIUtil.drawLine((Graphics)g, (int)x, (int)r.y, (int)(x + width), (int)r.y);
            UIUtil.drawLine((Graphics)g, (int)x, (int)r.y, (int)x, (int)(r.y + r.height - 1));
            UIUtil.drawLine((Graphics)g, (int)x, (int)(r.y + r.height - 1), (int)(x + width), (int)(r.y + r.height - 1));
        } else {
            int[] xPoints = new int[]{x, x, x + width - 1};
            int[] yPoints = new int[]{r.y - 4, r.y + 4, r.y};
            g.fillPolygon(xPoints, yPoints, 3);
            g.setColor(gutter.getOutlineColor(false));
            g.drawPolygon(xPoints, yPoints, 3);
        }
    }

    @Nullable
    private static Color brighter(Color color) {
        if (color == null) {
            return null;
        }
        float[] hsbStripeColor = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (hsbStripeColor[1] < 0.02f) {
            hsbStripeColor[2] = Math.min(1.0f, hsbStripeColor[2] * 1.3f);
        } else {
            hsbStripeColor[1] = (float)((double)hsbStripeColor[1] * 0.3);
            hsbStripeColor[2] = 1.0f;
        }
        return Color.getHSBColor(hsbStripeColor[0], hsbStripeColor[1], hsbStripeColor[2]);
    }

    public static LineMarkerRenderer createRenderer(final Range range, final LineStatusTracker tracker) {
        return new ActiveGutterRenderer(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                LineStatusTrackerDrawing.paintGutterFragment(editor, g, r, LineStatusTrackerDrawing.getDiffColor(range, true));
            }

            public void doAction(Editor editor, MouseEvent e) {
                e.consume();
                JComponent comp = (JComponent)e.getComponent();
                JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
                Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
                LineStatusTrackerDrawing.showActiveHint(range, editor, point, tracker);
            }

            public boolean canDoAction(MouseEvent e) {
                EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
                return e.getX() > gutter.getLineMarkerAreaOffset() + gutter.getIconsAreaWidth();
            }
        };
    }

    public static void showActiveHint(Range range, final Editor editor, Point point, LineStatusTracker tracker) {
        DefaultActionGroup group = new DefaultActionGroup();
        final ShowPrevChangeMarkerAction localShowPrevAction = new ShowPrevChangeMarkerAction(tracker.getPrevRange(range), tracker, editor);
        final ShowNextChangeMarkerAction localShowNextAction = new ShowNextChangeMarkerAction(tracker.getNextRange(range), tracker, editor);
        final RollbackLineStatusRangeAction rollback = new RollbackLineStatusRangeAction(tracker, range, editor);
        final ShowLineStatusRangeDiffAction showDiff = new ShowLineStatusRangeDiffAction(tracker, range, editor);
        final CopyLineStatusRangeAction copyRange = new CopyLineStatusRangeAction(tracker, range);
        group.add((AnAction)localShowPrevAction);
        group.add((AnAction)localShowNextAction);
        group.add((AnAction)rollback);
        group.add((AnAction)showDiff);
        group.add((AnAction)copyRange);
        JComponent editorComponent = editor.getComponent();
        EmptyAction.setupAction((AnAction)localShowPrevAction, (String)"VcsShowPrevChangeMarker", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)localShowNextAction, (String)"VcsShowNextChangeMarker", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)rollback, (String)"Vcs.RollbackChangedLines", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)showDiff, (String)"ChangesView.Diff", (JComponent)editorComponent);
        EmptyAction.setupAction((AnAction)copyRange, (String)"$Copy", (JComponent)editorComponent);
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group, true).getComponent();
        Color background = ((EditorEx)editor).getBackgroundColor();
        Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbar.setBackground(background);
        toolbar.setBorder(new ColoredSideBorder(foreground, foreground, range.getType() != 2 ? null : foreground, foreground, 1));
        JPanel component = new JPanel(new BorderLayout());
        component.setOpaque(false);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setOpaque(false);
        toolbarPanel.add((Component)toolbar, "West");
        JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        toolbarPanel.add((Component)emptyPanel, "Center");
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
            }
        };
        emptyPanel.addMouseListener(listener);
        component.add((Component)toolbarPanel, "North");
        if (range.getType() != 2) {
            DocumentEx doc = (DocumentEx)tracker.getVcsDocument();
            EditorEx uEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)doc, tracker.getProject());
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(tracker.getProject(), LineStatusTrackerDrawing.getFileName(tracker.getDocument()));
            uEditor.setHighlighter(highlighter);
            EditorFragmentComponent editorFragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(uEditor, range.getVcsLine1(), range.getVcsLine2(), false, false);
            component.add((Component)editorFragmentComponent, "Center");
            EditorFactory.getInstance().releaseEditor((Editor)uEditor);
        }
        final List actionList = ActionUtil.getActions((JComponent)editorComponent);
        LightweightHint lightweightHint = new LightweightHint(component);
        HintListener closeListener = new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                actionList.remove((Object)rollback);
                actionList.remove((Object)showDiff);
                actionList.remove((Object)copyRange);
                actionList.remove((Object)localShowPrevAction);
                actionList.remove((Object)localShowNextAction);
            }
        };
        lightweightHint.addHintListener(closeListener);
        HintManagerImpl.getInstanceImpl().showEditorHint(lightweightHint, editor, point, 42, -1, false, new HintHint(editor, point));
        if (!lightweightHint.isVisible()) {
            closeListener.hintHidden(null);
        }
    }

    private static String getFileName(Document document) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return "";
        }
        return file.getName();
    }

    public static void moveToRange(final Range range, final Editor editor, final LineStatusTracker tracker) {
        Document document = tracker.getDocument();
        final int lastOffset = document.getLineStartOffset(Math.min(range.getLine2(), document.getLineCount() - 1));
        editor.getCaretModel().moveToOffset(lastOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

            @Override
            public void run() {
                Point p = editor.visualPositionToXY(editor.offsetToVisualPosition(lastOffset));
                JComponent editorComponent = editor.getContentComponent();
                JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
                p = SwingUtilities.convertPoint(editorComponent, 0, p.y, layeredPane);
                LineStatusTrackerDrawing.showActiveHint(range, editor, p, tracker);
            }
        });
    }

    private static Color getDiffColor(Range range, boolean gutter) {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        switch (range.getType()) {
            case 2: {
                return gutter ? globalScheme.getColor(EditorColors.ADDED_LINES_COLOR) : globalScheme.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return globalScheme.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return gutter ? globalScheme.getColor(EditorColors.MODIFIED_LINES_COLOR) : globalScheme.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }
}

