/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.HorizontalScrollBarEditorCustomization;
import com.intellij.ui.OneLineEditorCustomization;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class NewEditChangelistPanel
extends JPanel {
    private EditorTextField myNameTextField;
    private EditorTextField myDescriptionTextArea;
    private JPanel myAdditionalControlsPanel;
    private JCheckBox myMakeActiveCheckBox;
    private Consumer<LocalChangeList> myConsumer;
    private final Project myProject;

    public NewEditChangelistPanel(Project project) {
        super(new GridBagLayout());
        this.myProject = project;
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
        JLabel nameLabel = new JLabel(VcsBundle.message((String)"edit.changelist.name", (Object[])new Object[0]));
        this.add((Component)nameLabel, gb);
        ++gb.gridx;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.myNameTextField = NewEditChangelistPanel.createEditorField(project, 1);
        this.myNameTextField.setOneLineMode(true);
        this.myNameTextField.setText("New changelist");
        this.myNameTextField.selectAll();
        this.add((Component)((Object)this.myNameTextField), gb);
        nameLabel.setLabelFor((Component)((Object)this.myNameTextField));
        ++gb.gridy;
        gb.gridx = 0;
        gb.weightx = 0.0;
        gb.fill = 0;
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"edit.changelist.description", (Object[])new Object[0]));
        this.add((Component)commentLabel, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.fill = 1;
        this.myDescriptionTextArea = NewEditChangelistPanel.createEditorField(project, 4);
        this.myDescriptionTextArea.setOneLineMode(false);
        this.add((Component)((Object)this.myDescriptionTextArea), gb);
        commentLabel.setLabelFor((Component)((Object)this.myDescriptionTextArea));
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        gb.weighty = 0.0;
        this.myAdditionalControlsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.myAdditionalControlsPanel, 0);
        this.myAdditionalControlsPanel.setLayout(layout);
        this.myMakeActiveCheckBox = new JCheckBox(VcsBundle.message((String)"new.changelist.make.active.checkbox", (Object[])new Object[0]));
        this.myAdditionalControlsPanel.add(this.myMakeActiveCheckBox);
        this.add((Component)this.myAdditionalControlsPanel, gb);
    }

    public JCheckBox getMakeActiveCheckBox() {
        return this.myMakeActiveCheckBox;
    }

    public void init(final LocalChangeList initial) {
        this.myMakeActiveCheckBox.setSelected(VcsConfiguration.getInstance((Project)this.myProject).MAKE_NEW_CHANGELIST_ACTIVE);
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)this.myProject)) {
            support.installSearch(this.myNameTextField, this.myDescriptionTextArea);
            this.myConsumer = support.addControls(this.myAdditionalControlsPanel, initial);
        }
        this.myNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                NewEditChangelistPanel.this.nameChangedImpl(NewEditChangelistPanel.this.myProject, initial);
            }
        });
        this.nameChangedImpl(this.myProject, initial);
    }

    protected void nameChangedImpl(Project project, LocalChangeList initial) {
        String name = this.getChangeListName();
        if (name == null || name.trim().length() == 0) {
            this.nameChanged("Cannot create new changelist with empty name.");
        } else if (!(initial != null && name.equals(initial.getName()) || ChangeListManager.getInstance((Project)project).findChangeList(name) == null)) {
            this.nameChanged(VcsBundle.message((String)"new.changelist.duplicate.name.error", (Object[])new Object[0]));
        } else {
            this.nameChanged(null);
        }
    }

    public void changelistCreatedOrChanged(LocalChangeList list) {
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)list);
        }
    }

    public void setChangeListName(String s) {
        this.myNameTextField.setText(s);
    }

    public String getChangeListName() {
        return this.myNameTextField.getText();
    }

    public void setDescription(String s) {
        this.myDescriptionTextArea.setText(s);
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText();
    }

    public JComponent getContent() {
        return this;
    }

    @Override
    public void requestFocus() {
        this.myNameTextField.requestFocus();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    protected abstract void nameChanged(String var1);

    private static EditorTextField createEditorField(Project project, int defaultLines) {
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project, EditorTextFieldProvider.class);
        HashSet editorFeatures = ContainerUtil.newHashSet();
        editorFeatures.add(SpellCheckingEditorCustomization.ENABLED);
        if (defaultLines == 1) {
            editorFeatures.add(HorizontalScrollBarEditorCustomization.DISABLED);
            editorFeatures.add(OneLineEditorCustomization.ENABLED);
        } else {
            editorFeatures.add(SoftWrapsEditorCustomization.ENABLED);
        }
        EditorTextField editorField = service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, editorFeatures);
        int height = editorField.getFontMetrics(editorField.getFont()).getHeight();
        editorField.getComponent().setMinimumSize(new Dimension(100, (int)((double)height * 1.3)));
        return editorField;
    }
}

