/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.Comparator;

public class ChangesComparator
implements Comparator<Change> {
    private static final ChangesComparator ourFlattenedInstance = new ChangesComparator(false);
    private static final ChangesComparator ourTreeInstance = new ChangesComparator(true);
    private final boolean myTreeCompare;

    public static ChangesComparator getInstance(boolean flattened) {
        if (flattened) {
            return ourFlattenedInstance;
        }
        return ourTreeInstance;
    }

    private ChangesComparator(boolean treeCompare) {
        this.myTreeCompare = treeCompare;
    }

    @Override
    public int compare(Change o1, Change o2) {
        FilePath filePath1 = ChangesUtil.getFilePath((Change)o1);
        FilePath filePath2 = ChangesUtil.getFilePath((Change)o2);
        if (this.myTreeCompare) {
            boolean isDirectory2;
            char c2;
            char c1;
            int index2;
            String path1 = FileUtilRt.toSystemIndependentName((String)filePath1.getPath());
            String path2 = FileUtilRt.toSystemIndependentName((String)filePath2.getPath());
            int index1 = 0;
            int start = 0;
            for (index2 = 0; index1 < path1.length() && index2 < path2.length() && StringUtil.compare((char)(c1 = path1.charAt(index1)), (char)(c2 = path2.charAt(index2)), (boolean)true) == 0; ++index1, ++index2) {
                if (c1 != '/') continue;
                start = index1;
            }
            if (index1 == path1.length() && index2 == path2.length()) {
                return 0;
            }
            if (index1 == path1.length()) {
                return -1;
            }
            if (index2 == path2.length()) {
                return 1;
            }
            int end1 = path1.indexOf(47, start + 1);
            int end2 = path2.indexOf(47, start + 1);
            String name1 = end1 == -1 ? path1.substring(start) : path1.substring(start, end1);
            String name2 = end2 == -1 ? path2.substring(start) : path2.substring(start, end2);
            boolean isDirectory1 = end1 != -1 || filePath1.isDirectory();
            boolean bl = isDirectory2 = end2 != -1 || filePath2.isDirectory();
            if (isDirectory1 && !isDirectory2) {
                return -1;
            }
            if (!isDirectory1 && isDirectory2) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        }
        return filePath1.getName().compareToIgnoreCase(filePath2.getName());
    }
}

