/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.MergedDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.patch.Strippable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePatchInProgress
implements Strippable {
    private final TextFilePatch myPatch;
    private final PatchStrippable myStrippable;
    private final FilePatchStatus myStatus;
    private VirtualFile myBase;
    private File myIoCurrentBase;
    private VirtualFile myCurrentBase;
    private boolean myBaseExists;
    private ContentRevision myNewContentRevision;
    private ContentRevision myCurrentRevision;
    private final List<VirtualFile> myAutoBases;
    private volatile Boolean myConflicts;
    private File myAfterFile;

    public FilePatchInProgress(TextFilePatch patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        this.myPatch = patch.pathsOnlyCopy();
        this.myStrippable = new PatchStrippable((FilePatch)patch);
        this.myAutoBases = new ArrayList<VirtualFile>();
        if (autoBases != null) {
            this.setAutoBases(autoBases);
        }
        this.myStatus = FilePatchInProgress.getStatus(this.myPatch);
        if (this.myAutoBases.isEmpty()) {
            this.setNewBase(baseDir);
        } else {
            this.setNewBase(this.myAutoBases.get(0));
        }
    }

    public void setAutoBases(@NotNull Collection<VirtualFile> autoBases) {
        if (autoBases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoBases", "com/intellij/openapi/vcs/changes/patch/FilePatchInProgress", "setAutoBases"));
        }
        String path = this.myPatch.getBeforeName() == null ? this.myPatch.getAfterName() : this.myPatch.getBeforeName();
        for (VirtualFile autoBase : autoBases) {
            VirtualFile willBeBase = PathMerger.getBase(autoBase, path);
            if (willBeBase == null) continue;
            this.myAutoBases.add(willBeBase);
        }
    }

    private static FilePatchStatus getStatus(TextFilePatch patch) {
        String beforeName = patch.getBeforeName().replace("\\", "/");
        String afterName = patch.getAfterName().replace("\\", "/");
        if (patch.isNewFile() || beforeName == null) {
            return FilePatchStatus.ADDED;
        }
        if (patch.isDeletedFile() || afterName == null) {
            return FilePatchStatus.DELETED;
        }
        if (beforeName.equals(afterName)) {
            return FilePatchStatus.MODIFIED;
        }
        return FilePatchStatus.MOVED_OR_RENAMED;
    }

    public PatchChange getChange() {
        return new PatchChange(this.getCurrentRevision(), this.getNewContentRevision(), this);
    }

    public void setNewBase(VirtualFile base) {
        this.myBase = base;
        this.myNewContentRevision = null;
        this.myCurrentRevision = null;
        this.myAfterFile = null;
        this.myConflicts = null;
        String beforeName = this.myPatch.getBeforeName();
        if (beforeName != null) {
            this.myIoCurrentBase = PathMerger.getFile(new File(this.myBase.getPath()), beforeName);
            this.myCurrentBase = this.myIoCurrentBase == null ? null : VcsUtil.getVirtualFileWithRefresh((File)this.myIoCurrentBase);
            this.myBaseExists = this.myCurrentBase != null && this.myCurrentBase.exists();
        } else {
            String afterName = this.myPatch.getAfterName();
            this.myBaseExists = true;
            this.myIoCurrentBase = PathMerger.getFile(new File(this.myBase.getPath()), afterName);
            this.myCurrentBase = VcsUtil.getVirtualFileWithRefresh((File)this.myIoCurrentBase);
        }
    }

    public void setCreatedCurrentBase(VirtualFile vf) {
        this.myCurrentBase = vf;
    }

    public FilePatchStatus getStatus() {
        return this.myStatus;
    }

    public File getIoCurrentBase() {
        return this.myIoCurrentBase;
    }

    public VirtualFile getCurrentBase() {
        return this.myCurrentBase;
    }

    public VirtualFile getBase() {
        return this.myBase;
    }

    public TextFilePatch getPatch() {
        return this.myPatch;
    }

    public boolean isBaseExists() {
        return this.myBaseExists;
    }

    public boolean baseExistsOrAdded() {
        return this.myBaseExists || FilePatchStatus.ADDED.equals((Object)this.myStatus);
    }

    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision == null) {
            this.myConflicts = null;
            if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
                FilePath newFilePath = FilePathImpl.createNonLocal(this.myIoCurrentBase.getAbsolutePath(), false);
                String content = this.myPatch.getNewFileText();
                this.myNewContentRevision = new SimpleContentRevision(content, newFilePath, this.myPatch.getAfterVersionId());
            } else {
                FilePathImpl newFilePath = FilePatchStatus.MOVED_OR_RENAMED.equals((Object)this.myStatus) ? new FilePathImpl(PathMerger.getFile(new File(this.myBase.getPath()), this.myPatch.getAfterName()), false) : (this.myCurrentBase != null ? new FilePathImpl(this.myCurrentBase) : new FilePathImpl(this.myIoCurrentBase, false));
                this.myNewContentRevision = new LazyPatchContentRevision(this.myCurrentBase, newFilePath, this.myPatch.getAfterVersionId(), this.myPatch);
                if (this.myCurrentBase != null) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            ((LazyPatchContentRevision)FilePatchInProgress.this.myNewContentRevision).getContent();
                        }
                    });
                }
            }
        }
        return this.myNewContentRevision;
    }

    public boolean isConflictingChange() {
        if (this.myConflicts == null) {
            if (this.myCurrentBase != null && this.myNewContentRevision instanceof LazyPatchContentRevision) {
                ((LazyPatchContentRevision)this.myNewContentRevision).getContent();
                this.myConflicts = ((LazyPatchContentRevision)this.myNewContentRevision).isPatchApplyFailed();
            } else {
                this.myConflicts = false;
            }
        }
        return this.myConflicts;
    }

    public ContentRevision getCurrentRevision() {
        if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myCurrentRevision == null) {
            FilePathImpl filePath = this.myCurrentBase != null ? new FilePathImpl(this.myCurrentBase) : new FilePathImpl(this.myIoCurrentBase, false);
            this.myCurrentRevision = new CurrentContentRevision((FilePath)filePath);
        }
        return this.myCurrentRevision;
    }

    public List<VirtualFile> getAutoBasesCopy() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myAutoBases.size() + 1);
        result.addAll(this.myAutoBases);
        return result;
    }

    public Couple<String> getKey() {
        return Couple.of((Object)this.myPatch.getBeforeName(), (Object)this.myPatch.getAfterName());
    }

    private void refresh() {
        this.myStrippable.applyBackToPatch((FilePatch)this.myPatch);
        this.setNewBase(this.myBase);
    }

    @Override
    public void reset() {
        this.myStrippable.reset();
        this.refresh();
    }

    @Override
    public boolean canDown() {
        return this.myStrippable.canDown();
    }

    @Override
    public boolean canUp() {
        return this.myStrippable.canUp();
    }

    @Override
    public void up() {
        this.myStrippable.up();
        this.refresh();
    }

    @Override
    public void down() {
        this.myStrippable.down();
        this.refresh();
    }

    @Override
    public void setZero() {
        this.myStrippable.setZero();
        this.refresh();
    }

    @Override
    public String getCurrentPath() {
        return this.myStrippable.getCurrentPath();
    }

    @Override
    public int getCurrentStrip() {
        return this.myStrippable.getCurrentStrip();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePatchInProgress that = (FilePatchInProgress)o;
        return this.myStrippable.equals(that.myStrippable);
    }

    public int hashCode() {
        return this.myStrippable.hashCode();
    }

    private static class PatchStrippable
    implements Strippable {
        private final Strippable[] myParts;
        private final int myBeforeIdx;
        private final int myAfterIdx;

        private PatchStrippable(FilePatch patch) {
            boolean onePath = patch.isDeletedFile() || patch.isNewFile() || Comparing.equal((String)patch.getAfterName(), (String)patch.getBeforeName());
            int size = onePath ? 1 : 2;
            this.myParts = new Strippable[size];
            int cnt = 0;
            if (patch.getAfterName() != null) {
                this.myAfterIdx = 0;
                this.myParts[cnt] = new StripCapablePath(patch.getAfterName());
                ++cnt;
            } else {
                this.myAfterIdx = -1;
            }
            if (cnt < size) {
                this.myParts[cnt] = new StripCapablePath(patch.getBeforeName());
                this.myBeforeIdx = cnt;
            } else {
                this.myBeforeIdx = 0;
            }
        }

        @Override
        public void reset() {
            for (Strippable part : this.myParts) {
                part.reset();
            }
        }

        @Override
        public boolean canDown() {
            boolean result = true;
            for (Strippable part : this.myParts) {
                result &= part.canDown();
            }
            return result;
        }

        @Override
        public boolean canUp() {
            boolean result = true;
            for (Strippable part : this.myParts) {
                result &= part.canUp();
            }
            return result;
        }

        @Override
        public void up() {
            for (Strippable part : this.myParts) {
                part.up();
            }
        }

        @Override
        public void down() {
            for (Strippable part : this.myParts) {
                part.down();
            }
        }

        @Override
        public void setZero() {
            for (Strippable part : this.myParts) {
                part.setZero();
            }
        }

        @Override
        public String getCurrentPath() {
            return this.myParts[0].getCurrentPath();
        }

        @Override
        public int getCurrentStrip() {
            return this.myParts[0].getCurrentStrip();
        }

        public void applyBackToPatch(FilePatch patch) {
            String afterName;
            String beforeName = patch.getBeforeName();
            if (beforeName != null) {
                patch.setBeforeName(this.myParts[this.myBeforeIdx].getCurrentPath());
            }
            if ((afterName = patch.getAfterName()) != null) {
                patch.setAfterName(this.myParts[this.myAfterIdx].getCurrentPath());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchStrippable that = (PatchStrippable)o;
            return Arrays.equals(this.myParts, that.myParts);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myParts);
        }
    }

    private static class StripCapablePath
    implements Strippable {
        private final int myStripMax;
        private int myCurrentStrip;
        private final StringBuilder mySourcePath;
        private final int[] myParts;

        private StripCapablePath(String path) {
            String corrected = path.trim().replace('\\', '/');
            this.mySourcePath = new StringBuilder(corrected);
            String[] steps = corrected.split("/");
            this.myStripMax = steps.length - 1;
            this.myParts = new int[steps.length];
            int pos = 0;
            for (int i = 0; i < steps.length; ++i) {
                String step = steps[i];
                this.myParts[i] = pos;
                pos += step.length() + 1;
            }
            this.myCurrentStrip = 0;
        }

        @Override
        public void reset() {
            this.myCurrentStrip = 0;
        }

        @Override
        public int getCurrentStrip() {
            return this.myCurrentStrip;
        }

        @Override
        public boolean canDown() {
            return this.myCurrentStrip > 0;
        }

        @Override
        public boolean canUp() {
            return this.myCurrentStrip < this.myStripMax;
        }

        @Override
        public void up() {
            if (this.canUp()) {
                ++this.myCurrentStrip;
            }
        }

        @Override
        public void down() {
            if (this.canDown()) {
                --this.myCurrentStrip;
            }
        }

        @Override
        public void setZero() {
            this.myCurrentStrip = this.myStripMax;
        }

        @Override
        public String getCurrentPath() {
            return this.mySourcePath.substring(this.myParts[this.myCurrentStrip]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StripCapablePath that = (StripCapablePath)o;
            return this.mySourcePath.equals(that.mySourcePath);
        }

        public int hashCode() {
            return this.mySourcePath.hashCode();
        }
    }

    public static class PatchChange
    extends Change {
        private final FilePatchInProgress myPatchInProgress;

        public PatchChange(ContentRevision beforeRevision, ContentRevision afterRevision, FilePatchInProgress patchInProgress) {
            super(beforeRevision, afterRevision, patchInProgress.isBaseExists() || FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus()) ? null : FileStatus.MERGED_WITH_CONFLICTS);
            this.myPatchInProgress = patchInProgress;
        }

        public FilePatchInProgress getPatchInProgress() {
            return this.myPatchInProgress;
        }

        @Nullable
        public DiffRequestPresentable createDiffRequestPresentable(final Project project, final Getter<CharSequence> baseContents) {
            return new DiffRequestPresentableProxy(){

                @Override
                @NotNull
                protected DiffRequestPresentable init() throws VcsException {
                    if (PatchChange.this.myPatchInProgress.isConflictingChange()) {
                        Getter<ApplyPatchForBaseRevisionTexts> revisionTextsGetter = new Getter<ApplyPatchForBaseRevisionTexts>(){

                            public ApplyPatchForBaseRevisionTexts get() {
                                return ApplyPatchForBaseRevisionTexts.create(project, PatchChange.this.myPatchInProgress.getCurrentBase(), new FilePathImpl(PatchChange.this.myPatchInProgress.getCurrentBase()), PatchChange.this.myPatchInProgress.getPatch(), (Getter<CharSequence>)baseContents);
                            }
                        };
                        MergedDiffRequestPresentable mergedDiffRequestPresentable = new MergedDiffRequestPresentable(project, revisionTextsGetter, PatchChange.this.myPatchInProgress.getCurrentBase(), PatchChange.this.myPatchInProgress.getPatch().getAfterVersionId());
                        if (mergedDiffRequestPresentable == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/FilePatchInProgress$PatchChange$1", "init"));
                        }
                        return mergedDiffRequestPresentable;
                    }
                    ChangeDiffRequestPresentable changeDiffRequestPresentable = new ChangeDiffRequestPresentable(project, PatchChange.this);
                    if (changeDiffRequestPresentable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/FilePatchInProgress$PatchChange$1", "init"));
                    }
                    return changeDiffRequestPresentable;
                }

                public String getPathPresentation() {
                    File ioCurrentBase = PatchChange.this.myPatchInProgress.getIoCurrentBase();
                    return ioCurrentBase == null ? PatchChange.this.myPatchInProgress.getCurrentPath() : ioCurrentBase.getPath();
                }
            };
        }
    }
}

