/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class IncomingChangesViewProvider
implements ChangesViewContentProvider {
    private final Project myProject;
    private final MessageBus myBus;
    private CommittedChangesTreeBrowser myBrowser;
    private MessageBusConnection myConnection;
    private Consumer<List<CommittedChangeList>> myListConsumer;

    public IncomingChangesViewProvider(Project project, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
        this.myListConsumer = new Consumer<List<CommittedChangeList>>(){

            public void consume(final List<CommittedChangeList> lists) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IncomingChangesViewProvider.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
                        IncomingChangesViewProvider.this.myBrowser.setItems(lists, CommittedChangesBrowserUseCase.INCOMING);
                    }
                });
            }
        };
    }

    @Override
    public JComponent initContent() {
        this.myBrowser = new CommittedChangesTreeBrowser(this.myProject, Collections.<CommittedChangeList>emptyList());
        this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.not.loaded.message", (Object[])new Object[0]));
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("IncomingChangesToolbar");
        ActionToolbar toolbar = this.myBrowser.createGroupFilterToolbar(this.myProject, group, null, Collections.<AnAction>emptyList());
        this.myBrowser.setToolBar(toolbar.getComponent());
        this.myBrowser.setTableContextMenu(group, Collections.<AnAction>emptyList());
        this.myConnection = this.myBus.connect();
        this.myConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new MyCommittedChangesListener());
        this.loadChangesToBrowser(false, true);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.myBrowser, "Center");
        return contentPane;
    }

    @Override
    public void disposeContent() {
        this.myConnection.disconnect();
        Disposer.dispose((Disposable)this.myBrowser);
        this.myBrowser = null;
    }

    private void updateModel(final boolean inBackground, final boolean refresh) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IncomingChangesViewProvider.this.myProject.isDisposed()) {
                    return;
                }
                if (IncomingChangesViewProvider.this.myBrowser != null) {
                    IncomingChangesViewProvider.this.loadChangesToBrowser(inBackground, refresh);
                }
            }
        });
    }

    private void loadChangesToBrowser(final boolean inBackground, final boolean refresh) {
        final CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
        cache.hasCachesForAnyRoot(new Consumer<Boolean>(){

            public void consume(Boolean notEmpty) {
                if (Boolean.TRUE.equals(notEmpty)) {
                    List<CommittedChangeList> list = cache.getCachedIncomingChanges();
                    if (list != null) {
                        IncomingChangesViewProvider.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
                        IncomingChangesViewProvider.this.myBrowser.setItems(list, CommittedChangesBrowserUseCase.INCOMING);
                    } else if (refresh) {
                        cache.loadIncomingChangesAsync((Consumer<List<CommittedChangeList>>)IncomingChangesViewProvider.this.myListConsumer, inBackground);
                    } else {
                        IncomingChangesViewProvider.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
                        IncomingChangesViewProvider.this.myBrowser.setItems(Collections.<CommittedChangeList>emptyList(), CommittedChangesBrowserUseCase.INCOMING);
                    }
                }
            }
        });
    }

    private class MyCommittedChangesListener
    extends CommittedChangesAdapter {
        private MyCommittedChangesListener() {
        }

        @Override
        public void changesLoaded(RepositoryLocation location, List<CommittedChangeList> changes) {
            IncomingChangesViewProvider.this.updateModel(true, true);
        }

        @Override
        public void incomingChangesUpdated(List<CommittedChangeList> receivedChanges) {
            IncomingChangesViewProvider.this.updateModel(true, true);
        }

        @Override
        public void presentationChanged() {
            IncomingChangesViewProvider.this.updateModel(true, false);
        }

        @Override
        public void changesCleared() {
            IncomingChangesViewProvider.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
            IncomingChangesViewProvider.this.myBrowser.setItems(Collections.<CommittedChangeList>emptyList(), CommittedChangesBrowserUseCase.INCOMING);
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            if (lastError != null) {
                VcsBalloonProblemNotifier.showOverChangesView(IncomingChangesViewProvider.this.myProject, lastError.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }
}

