/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean visible = project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        e.getPresentation().setVisible(visible);
        if (!visible) {
            return;
        }
        Change[] leadSelection = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION);
        boolean isEnabled = leadSelection != null && leadSelection.length > 0 || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_LOCALLY_DELETED)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES)) || RollbackAction.hasReversibleFiles(e, project);
        e.getPresentation().setEnabled(isEnabled);
        String operationName = RollbackUtil.getRollbackOperationName(project);
        e.getPresentation().setText(operationName + "...");
        if (isEnabled) {
            e.getPresentation().setDescription(UIUtil.removeMnemonic((String)operationName) + " selected changes");
        }
    }

    private static boolean hasReversibleFiles(AnActionEvent e, Project project) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
            HashSet modifiedWithoutEditing = ContainerUtil.newHashSet((Iterable)clManager.getModifiedWithoutEditing());
            for (VirtualFile file : files) {
                if (clManager.getChangesIn(file).isEmpty() && !modifiedWithoutEditing.contains(file)) continue;
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        String title;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        String string = title = "ChangesViewToolbar".equals(e.getPlace()) ? null : "Can not " + RollbackUtil.getRollbackOperationName(project) + " now";
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(title)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        boolean hasChanges = false;
        if (missingFiles != null && !missingFiles.isEmpty()) {
            hasChanges = true;
            new RollbackDeletionAction().actionPerformed(e);
        }
        List<Change> changes = RollbackAction.getChanges(project, e);
        LinkedHashSet<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project);
        if (modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty()) {
            hasChanges = true;
            RollbackAction.rollbackModifiedWithoutEditing(project, modifiedWithoutEditing);
        }
        if (changes != null) {
            if (modifiedWithoutEditing != null) {
                Iterator<Change> iterator = changes.iterator();
                while (iterator.hasNext()) {
                    Change next = iterator.next();
                    if (!modifiedWithoutEditing.contains(next.getVirtualFile())) continue;
                    iterator.remove();
                }
            }
            if (!changes.isEmpty() || !hasChanges) {
                RollbackChangesDialog.rollbackChanges(project, changes);
            }
        }
    }

    @Nullable
    private static List<Change> getChanges(Project project, AnActionEvent e) {
        ChangesCheckHelper helper = new ChangesCheckHelper(project, e);
        if (helper.isChangesSet() && helper.getChanges() != null) {
            return ContainerUtil.newArrayList((Object[])helper.getChanges());
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            ArrayList<Change> result = new ArrayList<Change>();
            for (VirtualFile file : virtualFiles) {
                result.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(file));
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static LinkedHashSet<VirtualFile> getModifiedWithoutEditing(AnActionEvent e, Project project) {
        List modifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (modifiedWithoutEditing != null && modifiedWithoutEditing.size() > 0) {
            return new LinkedHashSet<VirtualFile>(modifiedWithoutEditing);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>(Arrays.asList(virtualFiles));
            result.retainAll(ChangeListManager.getInstance((Project)project).getModifiedWithoutEditing());
            return result;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(final Project project, final LinkedHashSet<VirtualFile> modifiedWithoutEditing) {
        final String operationName = StringUtil.decapitalize((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project)));
        String message = modifiedWithoutEditing.size() == 1 ? VcsBundle.message((String)"rollback.modified.without.editing.confirm.single", (Object[])new Object[]{operationName, ((VirtualFile)modifiedWithoutEditing.iterator().next()).getPresentableUrl()}) : VcsBundle.message((String)"rollback.modified.without.editing.confirm.multiple", (Object[])new Object[]{operationName, modifiedWithoutEditing.size()});
        int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[]{operationName}), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        final ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator indicator = progressManager.getProgressIndicator();
                try {
                    ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)modifiedWithoutEditing, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

                        public void process(AbstractVcs vcs, List<VirtualFile> items) {
                            RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                            if (rollbackEnvironment != null) {
                                if (indicator != null) {
                                    indicator.setText(vcs.getDisplayName() + ": performing " + UIUtil.removeMnemonic((String)rollbackEnvironment.getRollbackOperationName()).toLowerCase() + "...");
                                    indicator.setIndeterminate(false);
                                }
                                rollbackEnvironment.rollbackModifiedWithoutCheckout(items, exceptions, (RollbackProgressListener)new RollbackProgressModifier(items.size(), indicator));
                                if (indicator != null) {
                                    indicator.setText2("");
                                }
                            }
                        }
                    });
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"rollback.modified.without.checkout.error.tab", (Object[])new Object[]{operationName}));
                }
                VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)modifiedWithoutEditing));
                VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile virtualFile : modifiedWithoutEditing) {
                            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(virtualFile);
                        }
                    }
                });
            }
        };
        progressManager.runProcessWithProgressSynchronously(action, operationName, true, project);
    }

    private static class ChangesCheckHelper {
        private Change[] myChanges;
        private final boolean myChangesSet;

        public ChangesCheckHelper(Project project, AnActionEvent e) {
            VirtualFile[] files;
            Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
            if (changes == null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
                LinkedList changesList = new LinkedList();
                for (VirtualFile vf : files) {
                    changesList.addAll(clManager.getChangesIn(vf));
                }
                if (!changesList.isEmpty()) {
                    changes = changesList.toArray(new Change[changesList.size()]);
                }
            }
            boolean bl = this.myChangesSet = changes != null && changes.length > 0;
            if (this.myChangesSet && ChangesUtil.allChangesInOneListOrWholeListsSelected((Project)project, (Change[])changes)) {
                this.myChanges = changes;
            }
        }

        public boolean isChangesSet() {
            return this.myChangesSet;
        }

        public Change[] getChanges() {
            return this.myChanges;
        }
    }
}

