/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private final Convertor<AnActionEvent, Change[]> myForUpdateConvertor;
    private final Convertor<AnActionEvent, Change[]> myForPerformConvertor;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.actions.RevertCommittedStuffAbstractAction");

    public RevertCommittedStuffAbstractAction(Convertor<AnActionEvent, Change[]> forUpdateConvertor, Convertor<AnActionEvent, Change[]> forPerformConvertor) {
        this.myForUpdateConvertor = forUpdateConvertor;
        this.myForPerformConvertor = forPerformConvertor;
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        Change[] changes = (Change[])this.myForPerformConvertor.convert((Object)e);
        if (changes == null || changes.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes);
        FileDocumentManager.getInstance().saveAllDocuments();
        String defaultName = null;
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0) {
            defaultName = VcsBundle.message((String)"revert.changes.default.name", (Object[])new Object[]{changeLists[0].getName()});
        }
        final ChangeListChooser chooser = new ChangeListChooser(project, ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", defaultName);
        chooser.show();
        if (!chooser.isOK()) {
            return;
        }
        final ArrayList patches = new ArrayList();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.message((String)"revert.changes.title", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$1", "run"));
                }
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    patches.addAll(IdeaTextPatchBuilder.buildPatch((Project)project, preprocessed, (String)baseDir.getPresentableUrl(), (boolean)true));
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Failed to revert changes: " + ex.getMessage()), (String)VcsBundle.message((String)"revert.changes.title", (Object[])new Object[0]));
                        }
                    }, null, (Project)this.myProject);
                    indicator.cancel();
                }
            }

            public void onSuccess() {
                new PatchApplier(project, baseDir, patches, chooser.getSelectedList(), null, null).execute();
            }
        });
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])this.myForUpdateConvertor.convert((Object)e);
        e.getPresentation().setEnabled(project != null && changes != null && changes.length > 0);
    }
}

