/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreatePatchFromChangesAction
extends AnAction
implements DumbAware {
    public CreatePatchFromChangesAction() {
        super(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]), VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]), AllIcons.Actions.CreatePatch);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null || changes.length == 0) {
            return;
        }
        String commitMessage = null;
        ShelvedChangeList[] shelvedChangeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        if (shelvedChangeLists != null && shelvedChangeLists.length > 0) {
            commitMessage = shelvedChangeLists[0].DESCRIPTION;
        } else {
            ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            if (changeLists != null && changeLists.length > 0) {
                commitMessage = changeLists[0].getComment();
            }
        }
        if (commitMessage == null) {
            commitMessage = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        }
        if (commitMessage == null) {
            commitMessage = "";
        }
        ArrayList<Change> changeCollection = new ArrayList<Change>();
        Collections.addAll(changeCollection, changes);
        CreatePatchFromChangesAction.createPatch(project, commitMessage, changeCollection);
    }

    public static void createPatch(Project project, String commitMessage, List<Change> changeCollection) {
        CreatePatchCommitExecutor executor = CreatePatchCommitExecutor.getInstance(project = project == null ? ProjectManager.getInstance().getDefaultProject() : project);
        CommitSession commitSession = executor.createCommitSession();
        if (commitSession instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)commitSession).setContext(new CommitContext());
        }
        SessionDialog sessionDialog = new SessionDialog(executor.getActionText(), project, commitSession, changeCollection, commitMessage);
        sessionDialog.show();
        if (!sessionDialog.isOK()) {
            return;
        }
        CreatePatchFromChangesAction.preloadContent(project, changeCollection);
        commitSession.execute(changeCollection, commitMessage);
    }

    private static void preloadContent(Project project, final List<Change> changes) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Change change : changes) {
                    this.checkLoadContent(change.getBeforeRevision());
                    this.checkLoadContent(change.getAfterRevision());
                }
            }

            private void checkLoadContent(ContentRevision revision) {
                ProgressManager.checkCanceled();
                if (revision != null && !(revision instanceof BinaryContentRevision)) {
                    try {
                        revision.getContent();
                    }
                    catch (VcsException vcsException) {
                        // empty catch block
                    }
                }
            }
        }, VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true, project);
    }

    public void update(AnActionEvent e) {
        Change[] changes;
        Boolean haveSelectedChanges = (Boolean)e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES);
        ChangeList[] data1 = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        ShelvedChangeList[] data2 = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        ShelvedChangeList[] data3 = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY);
        int sum = data1 == null ? 0 : data1.length;
        sum += data2 == null ? 0 : data2.length;
        e.getPresentation().setEnabled(Boolean.TRUE.equals(haveSelectedChanges) && (sum += data3 == null ? 0 : data3.length) == 1 && (changes = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && changes.length > 0);
    }
}

