/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import org.jetbrains.annotations.NotNull;

public class Waiter
extends Task.Modal {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.Waiter");
    private final ModalityState myState;
    private final Runnable myRunnable;
    private boolean myStarted;
    private boolean myDone;
    private final Object myLock = new Object();

    public Waiter(Project project, Runnable runnable, ModalityState state2, String title, boolean cancellable) {
        super(project, title, cancellable);
        this.myRunnable = runnable;
        this.myState = state2;
        this.myDone = false;
        this.myStarted = false;
        this.setCancelText("Skip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/Waiter", "run"));
        }
        indicator.setIndeterminate(true);
        indicator.setText2(VcsBundle.message((String)"commit.wait.util.synched.text", (Object[])new Object[0]));
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStarted) {
                this.LOG.error("Waiter running under progress being started again.");
                return;
            }
            this.myStarted = true;
            while (!this.myDone) {
                try {
                    this.myLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                indicator.checkCanceled();
            }
        }
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myRunnable.run();
        ChangesViewManager.getInstance(this.myProject).scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDone = true;
            this.myLock.notifyAll();
        }
    }
}

