/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.Details;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.GenericDetailsLoader;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DetailsPanel;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.VcsChangeDetailsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcsUtil.UIVcsUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ShortDiffDetails
implements RefreshablePanel<Change>,
Disposable {
    private final Project myProject;
    private final VcsChangeDetailsManager myVcsChangeDetailsManager;
    private final Getter<Change[]> myMaster;
    private DetailsPanel myDetailsPanel;
    private GenericDetailsLoader<Change, RefreshablePanel> myDetailsLoader;
    private PairConsumer<Change, RefreshablePanel> myDetailsConsumer;
    private final SLRUMap<FilePath, RefreshablePanel> myDetailsCache;
    private FilePath myCurrentFilePath;
    private JComponent myParent;
    private RefreshablePanel myCurrentPanel;

    public ShortDiffDetails(Project project, Getter<Change[]> master, VcsChangeDetailsManager vcsChangeDetailsManager) {
        this.myMaster = master;
        this.myProject = project;
        this.myVcsChangeDetailsManager = vcsChangeDetailsManager;
        this.myDetailsCache = new SLRUMap<FilePath, RefreshablePanel>(10, 10){

            protected void onDropFromCache(FilePath key, RefreshablePanel value) {
                if (value != null) {
                    Disposer.dispose((Disposable)value);
                }
            }
        };
    }

    @Override
    public boolean isStillValid(Change change) {
        return true;
    }

    @Override
    public boolean refreshDataSynch() {
        Change selected = (Change)this.myDetailsLoader.getCurrentlySelected();
        if (selected == null) {
            return false;
        }
        if (this.myCurrentPanel != null) {
            return this.myCurrentPanel.refreshDataSynch();
        }
        return false;
    }

    public void setParent(JComponent parent) {
        this.myParent = parent;
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void refresh() {
        this.ensureDetailsCreated();
        this.myCurrentFilePath = this.setDetails();
        this.myDetailsPanel.layout();
    }

    public FilePath getCurrentFilePath() {
        return this.myCurrentFilePath;
    }

    @Nullable
    private FilePath setDetails() {
        FilePath currentFilePath = null;
        Change[] selectedChanges = (Change[])this.myMaster.get();
        if (selectedChanges.length == 0) {
            this.myDetailsPanel.nothingSelected();
        } else {
            String freezed = ChangeListManager.getInstance((Project)this.myProject).isFreezed();
            if (freezed != null) {
                this.myDetailsPanel.data(UIVcsUtil.errorPanel((String)freezed, (boolean)false));
                return currentFilePath;
            }
            this.myDetailsPanel.notAvailable();
            for (Change change : selectedChanges) {
                if (change.getBeforeRevision() instanceof FakeRevision || change.getAfterRevision() instanceof FakeRevision) {
                    this.myDetailsPanel.loadingInitial();
                    return currentFilePath;
                }
                if (!this.myVcsChangeDetailsManager.canComment(change)) continue;
                currentFilePath = ChangesUtil.getFilePath((Change)change);
                this.myDetailsLoader.updateSelection((Object)change, true);
                return currentFilePath;
            }
            this.myDetailsPanel.notAvailable();
        }
        return currentFilePath;
    }

    @Override
    public JPanel getPanel() {
        this.ensureDetailsCreated();
        return this.myDetailsPanel.getPanel();
    }

    @Override
    public void away() {
    }

    private void ensureDetailsCreated() {
        if (this.myDetailsConsumer != null) {
            return;
        }
        this.myDetailsPanel = new DetailsPanel();
        PairConsumer<Change, RefreshablePanel> cacheConsumer = new PairConsumer<Change, RefreshablePanel>(){

            public void consume(Change change, RefreshablePanel pair) {
                FilePath filePath = ChangesUtil.getFilePath((Change)change);
                RefreshablePanel old = (RefreshablePanel)ShortDiffDetails.this.myDetailsCache.get((Object)filePath);
                if (old == null) {
                    ShortDiffDetails.this.myDetailsCache.put((Object)filePath, (Object)pair);
                } else if (old != pair && pair != null) {
                    ShortDiffDetails.this.myDetailsCache.put((Object)filePath, (Object)pair);
                    Disposer.dispose((Disposable)old);
                }
            }
        };
        this.myDetailsConsumer = new PairConsumer<Change, RefreshablePanel>((PairConsumer)cacheConsumer){
            final /* synthetic */ PairConsumer val$cacheConsumer;
            {
                this.val$cacheConsumer = pairConsumer;
            }

            public void consume(Change change, RefreshablePanel pair) {
                this.val$cacheConsumer.consume((Object)change, (Object)pair);
                pair.refresh();
                ShortDiffDetails.this.myCurrentPanel = pair;
                ShortDiffDetails.this.myDetailsPanel.data(ShortDiffDetails.this.myCurrentPanel.getPanel());
                ShortDiffDetails.this.myDetailsPanel.layout();
            }
        };
        this.myDetailsLoader = new GenericDetailsLoader((Consumer)new Consumer<Change>(){

            public void consume(Change change) {
                if (ShortDiffDetails.this.myCurrentPanel != null) {
                    ShortDiffDetails.this.myCurrentPanel.away();
                }
                FilePath filePath = ChangesUtil.getFilePath((Change)change);
                RefreshablePanel details = (RefreshablePanel)ShortDiffDetails.this.myDetailsCache.get((Object)filePath);
                if (details != null && !details.isStillValid(change)) {
                    Disposer.dispose((Disposable)details);
                    details = null;
                    ShortDiffDetails.this.myDetailsLoader.resetValueConsumer();
                }
                if (details != null) {
                    ShortDiffDetails.this.myDetailsConsumer.consume((Object)change, (Object)details);
                } else {
                    RefreshablePanel detailsPanel = ShortDiffDetails.this.myVcsChangeDetailsManager.getPanel(change, ShortDiffDetails.this.myParent);
                    if (detailsPanel != null) {
                        try {
                            ShortDiffDetails.this.myDetailsLoader.take((Object)change, (Object)detailsPanel);
                        }
                        catch (Details.AlreadyDisposedException e) {
                            Disposer.dispose((Disposable)detailsPanel);
                        }
                    }
                }
            }
        }, this.myDetailsConsumer);
        this.myDetailsLoader.setCacheConsumer((PairConsumer)cacheConsumer);
    }

    public void dispose() {
        if (this.myDetailsLoader != null) {
            Disposer.dispose(this.myDetailsLoader);
        }
        if (this.myDetailsPanel != null) {
            this.myDetailsPanel.clear();
        }
        this.myDetailsCache.clear();
    }

    public boolean refreshData(VirtualFile vf) {
        RefreshablePanel panel = (RefreshablePanel)this.myDetailsCache.get((Object)new FilePathImpl(vf));
        if (panel != null) {
            panel.dataChanged();
            return true;
        }
        return false;
    }
}

