/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.MapIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IgnoredFilesCompositeHolder
implements IgnoredFilesHolder {
    private final Map<AbstractVcs, IgnoredFilesHolder> myHolderMap;
    private final Project myProject;
    private AbstractVcs myCurrentVcs;
    private final ProjectLevelVcsManager myVcsManager;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder");

    public IgnoredFilesCompositeHolder(Project project) {
        this.myProject = project;
        this.myHolderMap = new HashMap<AbstractVcs, IgnoredFilesHolder>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myHolderMap.clear();
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        AbstractVcs vcs = scope.getVcs();
        if (this.myHolderMap.containsKey(vcs)) {
            this.myHolderMap.get(vcs).cleanAndAdjustScope(scope);
        }
    }

    @Override
    public FileHolder copy() {
        IgnoredFilesCompositeHolder result = new IgnoredFilesCompositeHolder(this.myProject);
        for (Map.Entry<AbstractVcs, IgnoredFilesHolder> entry : this.myHolderMap.entrySet()) {
            result.myHolderMap.put(entry.getKey(), (IgnoredFilesHolder)entry.getValue().copy());
        }
        return result;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    @Nullable
    public IgnoredFilesHolder getAppropriateIgnoredHolder() {
        if (!this.myHolderMap.containsKey(this.myCurrentVcs)) {
            LOG.error("current vcs: " + this.myCurrentVcs);
            return null;
        }
        return this.myHolderMap.get(this.myCurrentVcs);
    }

    @Override
    public void addFile(VirtualFile file) {
        if (!this.myHolderMap.containsKey(this.myCurrentVcs)) {
            LOG.error("current vcs: " + this.myCurrentVcs + " file: " + file.getPath());
        }
        this.myHolderMap.get(this.myCurrentVcs).addFile(file);
    }

    @Override
    public boolean containsFile(VirtualFile file) {
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file);
        if (vcs == null) {
            return false;
        }
        IgnoredFilesHolder ignoredFilesHolder = this.myHolderMap.get(vcs);
        return ignoredFilesHolder == null ? false : ignoredFilesHolder.containsFile(file);
    }

    @Override
    public Collection<VirtualFile> values() {
        if (this.myHolderMap.size() == 1) {
            return this.myHolderMap.values().iterator().next().values();
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (IgnoredFilesHolder holder : this.myHolderMap.values()) {
            result.addAll(holder.values());
        }
        return result;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
        this.myCurrentVcs = vcs;
        if (!this.myHolderMap.containsKey(vcs)) {
            this.myHolderMap.put(vcs, vcs.reportsIgnoredDirectories() ? new RecursiveFileHolder(this.myProject, FileHolder.HolderType.IGNORED) : new MapIgnoredFilesHolder(this.myProject));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IgnoredFilesCompositeHolder)) {
            return false;
        }
        IgnoredFilesCompositeHolder other = (IgnoredFilesCompositeHolder)obj;
        return ((Object)this.myHolderMap).equals(other.myHolderMap);
    }

    public int hashCode() {
        return ((Object)this.myHolderMap).hashCode();
    }
}

