/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.FragmentedContent;
import com.intellij.openapi.vcs.changes.PreparedFragmentedContent;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FragmentedDiffRequestFromChange {
    private final Project myProject;
    private final SLRUMap<Pair<Long, String>, List<BeforeAfter<TextRange>>> myRangesCache;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.FragmentedDiffRequestFromChange");

    public FragmentedDiffRequestFromChange(Project project) {
        this.myProject = project;
        this.myRangesCache = new SLRUMap(10, 10);
    }

    public static boolean canCreateRequest(Change change) {
        if (ChangesUtil.isTextConflictingChange((Change)change) || change.isTreeConflict() || change.isPhantom()) {
            return false;
        }
        if (ShowDiffAction.isBinaryChange(change)) {
            return false;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        return !filePath.isDirectory();
    }

    public PreparedFragmentedContent getRanges(Change change) throws VcsException {
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        RangesCalculator calculator = new RangesCalculator();
        calculator.execute(change, filePath, this.myRangesCache, LineStatusTrackerManager.getInstance(this.myProject));
        VcsException exception = calculator.getException();
        if (exception != null) {
            LOG.info((Throwable)exception);
            throw exception;
        }
        List<BeforeAfter<TextRange>> ranges = calculator.getRanges();
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        FragmentedContent fragmentedContent = new FragmentedContent(calculator.getOldDocument(), calculator.getDocument(), ranges, change);
        VirtualFile file = filePath.getVirtualFile();
        if (file == null) {
            filePath.hardRefresh();
            file = filePath.getVirtualFile();
        }
        PreparedFragmentedContent preparedFragmentedContent = new PreparedFragmentedContent(this.myProject, fragmentedContent, filePath.getName(), filePath.getFileType(), change.getBeforeRevision() == null ? null : change.getBeforeRevision().getRevisionNumber(), change.getAfterRevision() == null ? null : change.getAfterRevision().getRevisionNumber(), filePath, file);
        return preparedFragmentedContent;
    }

    private static class MyWorker {
        private final Document myDocument;
        private final Document myOldDocument;
        private final List<Range> myRanges;

        private MyWorker(Document document, Document oldDocument, List<Range> ranges) {
            this.myDocument = document;
            this.myOldDocument = oldDocument;
            this.myRanges = ranges;
        }

        @Nullable
        public List<BeforeAfter<TextRange>> execute() {
            ArrayList<BeforeAfter<TextRange>> result = new ArrayList<BeforeAfter<TextRange>>();
            if (this.myRanges == null || this.myRanges.isEmpty()) {
                return Collections.emptyList();
            }
            for (Range range : this.myRanges) {
                TextRange before = new TextRange(range.getVcsLine1(), range.getVcsLine2());
                TextRange after = new TextRange(range.getLine1(), range.getLine2());
                result.add((BeforeAfter<TextRange>)new BeforeAfter((Object)before, (Object)after));
            }
            return result;
        }
    }

    private static class RangesCalculator {
        private List<BeforeAfter<TextRange>> myRanges;
        private VcsException myException;
        private Document myDocument;
        private Document myOldDocument;

        private RangesCalculator() {
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public Document getOldDocument() {
            return this.myOldDocument;
        }

        public void execute(Change change, FilePath filePath, SLRUMap<Pair<Long, String>, List<BeforeAfter<TextRange>>> cache, LineStatusTrackerManagerI lstManager) {
            try {
                ComparisonPolicy comparisonPolicy;
                List cached;
                this.myDocument = null;
                this.myOldDocument = this.documentFromRevision(change.getBeforeRevision());
                String convertedPath = FilePathsHelper.convertPath((FilePath)filePath);
                if (filePath.getVirtualFile() != null) {
                    DocumentImpl documentImpl = this.myDocument = FileStatus.DELETED.equals(change.getFileStatus()) ? new DocumentImpl("") : FileDocumentManager.getInstance().getDocument(filePath.getVirtualFile());
                    if (this.myDocument != null && (cached = (List)cache.get((Object)new Pair((Object)this.myDocument.getModificationStamp(), (Object)convertedPath))) != null) {
                        this.myRanges = cached;
                        return;
                    }
                }
                if (this.myDocument == null) {
                    this.myDocument = this.documentFromRevision(change.getAfterRevision());
                    cached = (List)cache.get((Object)new Pair((Object)-1L, (Object)convertedPath));
                    if (cached != null) {
                        this.myRanges = cached;
                        return;
                    }
                }
                if ((comparisonPolicy = DiffManagerImpl.getInstanceEx().getComparisonPolicy()) == null) {
                    comparisonPolicy = ComparisonPolicy.DEFAULT;
                }
                TextCompareProcessor processor = new TextCompareProcessor(comparisonPolicy);
                List lineFragments = processor.process(this.myOldDocument.getText(), this.myDocument.getText());
                this.myRanges = new ArrayList<BeforeAfter<TextRange>>(lineFragments.size());
                for (LineFragment lineFragment : lineFragments) {
                    if (lineFragment.isEqual()) continue;
                    TextRange oldRange = lineFragment.getRange(FragmentSide.SIDE1);
                    TextRange newRange = lineFragment.getRange(FragmentSide.SIDE2);
                    int beforeBegin = this.myOldDocument.getLineNumber(oldRange.getStartOffset());
                    int beforeEnd = this.myOldDocument.getLineNumber(this.correctRangeEnd(oldRange.getEndOffset(), this.myOldDocument));
                    int afterBegin = this.myDocument.getLineNumber(newRange.getStartOffset());
                    int afterEnd = this.myDocument.getLineNumber(this.correctRangeEnd(newRange.getEndOffset(), this.myDocument));
                    if (oldRange.isEmpty()) {
                        beforeEnd = beforeBegin - 1;
                    }
                    if (newRange.isEmpty()) {
                        afterEnd = afterBegin - 1;
                    }
                    this.myRanges.add((BeforeAfter<TextRange>)new BeforeAfter((Object)new UnfairTextRange(beforeBegin, beforeEnd), (Object)new UnfairTextRange(afterBegin, afterEnd)));
                }
                cache.put((Object)new Pair((Object)this.myDocument.getModificationStamp(), (Object)convertedPath), new ArrayList<BeforeAfter<TextRange>>(this.myRanges));
            }
            catch (VcsException e) {
                this.myException = e;
            }
            catch (FilesTooBigForDiffException e) {
                this.myException = new VcsException((Throwable)e);
            }
        }

        private int correctRangeEnd(int end, Document document) {
            if (end == 0) {
                return end;
            }
            return "\n".equals(document.getText(new TextRange(end - 1, end))) ? end - 1 : end;
        }

        public List<BeforeAfter<TextRange>> getRanges() {
            return this.myRanges;
        }

        public VcsException getException() {
            return this.myException;
        }

        private Document documentFromRevision(ContentRevision cr) throws VcsException {
            DocumentImpl oldDocument = new DocumentImpl(StringUtil.convertLineSeparators((String)this.notNullContentRevision(cr)), true);
            oldDocument.setReadOnly(true);
            return oldDocument;
        }

        private String notNullContentRevision(ContentRevision cr) throws VcsException {
            if (cr == null) {
                return "";
            }
            String content = cr.getContent();
            return content == null ? "" : content;
        }
    }
}

