/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.vcs.changes.CallbackData");
    private final Runnable myCallback;
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @Nullable Runnable wrapperStarter) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/vcs/changes/CallbackData", "<init>"));
        }
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    public Runnable getCallback() {
        return this.myCallback;
    }

    public Runnable getWrapperStarter() {
        return this.myWrapperStarter;
    }

    public static CallbackData create(final @NotNull Runnable afterUpdate, String title, ModalityState state2, final InvokeAfterUpdateMode mode, final @NotNull Project project) {
        if (afterUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterUpdate", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CallbackData", "create"));
        }
        if (mode.isSilently()) {
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    if (mode.isCallbackOnAwt()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LOG.debug("invokeAfterUpdate: silent wrapper called for project: " + project.getName());
                                if (project.isDisposed()) {
                                    return;
                                }
                                afterUpdate.run();
                                ChangesViewManager.getInstance(project).scheduleRefresh();
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!project.isDisposed()) {
                                    afterUpdate.run();
                                }
                            }
                        });
                    }
                }
            }, null);
        }
        if (mode.isSynchronous()) {
            final Waiter waiter = new Waiter(project, afterUpdate, state2, VcsBundle.message((String)"change.list.manager.wait.lists.synchronization", (Object[])new Object[]{title}), mode.isCancellable());
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("invokeAfterUpdate: NOT silent SYNCHRONOUS wrapper called for project: " + project.getName());
                    waiter.done();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)waiter);
                }
            });
        }
        final FictiveBackgroundable fictiveBackgroundable = new FictiveBackgroundable(project, afterUpdate, mode.isCancellable(), title, state2);
        return new CallbackData(new Runnable(){

            @Override
            public void run() {
                LOG.debug("invokeAfterUpdate: NOT silent wrapper called for project: " + project.getName());
                fictiveBackgroundable.done();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)fictiveBackgroundable);
            }
        });
    }
}

