/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Iterator;

abstract class AbstractIgnoredFilesHolder
implements FileHolder,
IgnoredFilesHolder {
    protected final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;

    protected AbstractIgnoredFilesHolder(Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
    }

    protected abstract void removeFile(VirtualFile var1);

    protected abstract Collection<VirtualFile> keys();

    @Override
    public void cleanAndAdjustScope(final VcsModifiableDirtyScope scope) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (AbstractIgnoredFilesHolder.this.myProject.isDisposed()) {
                    return;
                }
                Iterator<VirtualFile> iterator = AbstractIgnoredFilesHolder.this.keys().iterator();
                while (iterator.hasNext()) {
                    VirtualFile file = iterator.next();
                    if (!AbstractIgnoredFilesHolder.this.isFileDirty((VcsDirtyScope)scope, file)) continue;
                    iterator.remove();
                }
            }
        });
    }

    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file) {
        if (!file.isValid()) {
            return true;
        }
        final AbstractVcs[] vcsArr = new AbstractVcs[1];
        if (scope.belongsTo((FilePath)new FilePathImpl(file), (Consumer)new Consumer<AbstractVcs>(){

            public void consume(AbstractVcs vcs) {
                vcsArr[0] = vcs;
            }
        })) {
            return true;
        }
        return vcsArr[0] == null;
    }

    protected boolean fileDropped(VirtualFile file) {
        return !file.isValid() || this.myVcsManager.getVcsFor(file) == null;
    }
}

