/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    protected final DataContext myContext;
    protected final int myModifiers;
    private final String myPlace;
    private final String myActionName;

    public VcsContextWrapper(DataContext context, int modifiers, String place, String actionName) {
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    public String getPlace() {
        return this.myPlace;
    }

    public String getActionName() {
        return this.myActionName;
    }

    public static VcsContext createCachedInstanceOn(AnActionEvent event) {
        return new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
    }

    public static VcsContextWrapper createInstanceOn(AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    public VirtualFile getSelectedFile() {
        VirtualFile[] files = this.getSelectedFiles();
        return files.length == 0 ? null : files[0];
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            VirtualFile[] virtualFileArray = VcsContextWrapper.filterLocalFiles(fileArray);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
            }
            return virtualFileArray;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (virtualFile != null && VcsContextWrapper.isLocal(virtualFile)) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile};
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private static boolean isLocal(VirtualFile virtualFile) {
        return virtualFile.isInLocalFileSystem();
    }

    private static VirtualFile[] filterLocalFiles(VirtualFile[] fileArray) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : fileArray) {
            if (!VcsContextWrapper.isLocal(virtualFile)) continue;
            result.add(virtualFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    public File getSelectedIOFile() {
        File file = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file != null) {
            return file;
        }
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public File[] getSelectedIOFiles() {
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files != null && files.length > 0) {
            return files;
        }
        File file = this.getSelectedIOFile();
        if (file != null) {
            return new File[]{file};
        }
        return null;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        VirtualFile[] selectedFiles;
        FilePath[] paths;
        THashSet result = new THashSet();
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        if (path != null) {
            result.add(path);
        }
        if ((paths = (FilePath[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext)) != null) {
            for (FilePath filePath : paths) {
                if (result.contains(filePath)) continue;
                result.add(filePath);
            }
        }
        for (VirtualFile selectedFile : selectedFiles = this.getSelectedFiles()) {
            FilePathImpl filePath = new FilePathImpl(selectedFile);
            result.add(filePath);
        }
        File[] selectedIOFiles = this.getSelectedIOFiles();
        if (selectedIOFiles != null) {
            for (File selectedFile : selectedIOFiles) {
                FilePathImpl filePath = FilePathImpl.create(selectedFile);
                if (filePath == null) continue;
                result.add(filePath);
            }
        }
        FilePath[] filePathArray = result.toArray(new FilePath[result.size()]);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilePaths"));
        }
        return filePathArray;
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        FilePath[] selectedFilePaths = this.getSelectedFilePaths();
        if (selectedFilePaths.length == 0) {
            return null;
        }
        return selectedFilePaths[0];
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }
}

