/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class SelectAndCompareWithSelectedRevisionAction
extends AbstractVcsAction {
    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        VcsRevisionNumber vcsRevisionNumber;
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction", "actionPerformed"));
        }
        VirtualFile file = vcsContext.getSelectedFiles()[0];
        Project project = vcsContext.getProject();
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return;
        }
        RevisionSelector selector = vcs.getRevisionSelector();
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (selector != null && (vcsRevisionNumber = selector.selectNumber(file)) != null) {
            DiffActionExecutor.showDiff(diffProvider, vcsRevisionNumber, file, project, VcsBackgroundableActions.COMPARE_WITH);
        }
    }

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext, VcsBackgroundableActions.COMPARE_WITH);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }
}

