/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.Map;

class CurrentRevisionAnnotationFieldGutter
extends AnnotationFieldGutter
implements Consumer<AnnotationSource> {
    private boolean myTurnedOn;

    CurrentRevisionAnnotationFieldGutter(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation highlighting, Map<String, Color> colorScheme) {
        super(annotation, editor, aspect, highlighting, colorScheme);
    }

    @Override
    public ColorKey getColor(int line, Editor editor) {
        return AnnotationSource.LOCAL.getColor();
    }

    @Override
    public String getLineText(int line, Editor editor) {
        String value = this.myAspect.getValue(line);
        if (String.valueOf(this.myAnnotation.getLineRevisionNumber(line)).equals(value)) {
            return "";
        }
        return this.myTurnedOn ? value : "";
    }

    @Override
    public String getToolTip(int line, Editor editor) {
        String aspectTooltip = this.myAspect.getTooltipText(line);
        if (aspectTooltip != null) {
            return aspectTooltip;
        }
        String text = this.getLineText(line, editor);
        return text == null || text.length() == 0 ? "" : VcsBundle.message((String)"annotation.original.revision.text", (Object[])new Object[]{text});
    }

    public void consume(AnnotationSource annotationSource) {
        this.myTurnedOn = annotationSource.showMerged();
    }
}

