/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;

public class PatchInfo {
    private final BuildNumber myFromBuild;
    private final String mySize;
    private final Set<String> myExcludedOSes = new HashSet<String>();

    public PatchInfo(Element node) {
        this.myFromBuild = BuildNumber.fromString((String)node.getAttributeValue("from"));
        this.mySize = node.getAttributeValue("size");
        String excluded = node.getAttributeValue("exclusions");
        if (excluded != null) {
            this.myExcludedOSes.addAll(ContainerUtil.map((Collection)StringUtil.split((String)excluded, (String)","), (Function)new Function<String, String>(){

                public String fun(String s) {
                    return s.trim();
                }
            }));
        }
    }

    public BuildNumber getFromBuild() {
        return this.myFromBuild;
    }

    public String getSize() {
        return this.mySize;
    }

    public boolean isAvailable() {
        return !this.myExcludedOSes.contains(this.getOSSuffix());
    }

    public String getOSSuffix() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isUnix) {
            return "unix";
        }
        return "unknown";
    }
}

