/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ChannelStatus
implements Comparable<ChannelStatus> {
    @NonNls
    public static final String EAP_CODE = "eap";
    @NonNls
    public static final String RELEASE_CODE = "release";
    public static final ChannelStatus EAP = new ChannelStatus(0, "eap", "Early Access Program");
    public static final ChannelStatus MILESTONE = new ChannelStatus(1, "milestone", "Milestone Releases");
    public static final ChannelStatus BETA = new ChannelStatus(2, "beta", "Beta Releases or Public Previews");
    public static final ChannelStatus RELEASE = new ChannelStatus(3, "release", "New Major Version Releases");
    private static final List<ChannelStatus> ALL_TYPES = ContainerUtil.immutableList((Object[])new ChannelStatus[]{RELEASE, BETA, MILESTONE, EAP});
    private final int myOrder;
    private final String myCode;
    private final String myDisplayName;

    private ChannelStatus(int order, String code, String displayName) {
        this.myOrder = order;
        this.myCode = code;
        this.myDisplayName = displayName;
    }

    public static ChannelStatus fromCode(String code) {
        if (EAP_CODE.equalsIgnoreCase(code)) {
            return EAP;
        }
        if ("milestone".equalsIgnoreCase(code)) {
            return MILESTONE;
        }
        if ("beta".equalsIgnoreCase(code)) {
            return BETA;
        }
        return RELEASE;
    }

    @Override
    public int compareTo(ChannelStatus o) {
        return this.myOrder - o.myOrder;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public static List<ChannelStatus> all() {
        return ALL_TYPES;
    }

    public String toString() {
        return this.myDisplayName;
    }
}

