/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.AWTKeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ActionCommand
extends TypeCommand {
    public static String PREFIX = "%action";

    public ActionCommand(String text, int line) {
        super(text, line);
    }

    @Override
    protected ActionCallback _execute(final PlaybackContext context) {
        final String actionName = this.getText().substring(PREFIX.length()).trim();
        final ActionManager am = ActionManager.getInstance();
        final AnAction targetAction = am.getAction(actionName);
        if (targetAction == null) {
            this.dumpError(context, "Unknown action: " + actionName);
            return new ActionCallback.Rejected();
        }
        if (!context.isUseDirectActionCall()) {
            Shortcut[] sc = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionName);
            KeyStroke stroke = null;
            for (Shortcut each : sc) {
                if (!(each instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ks = (KeyboardShortcut)each;
                KeyStroke first = ks.getFirstKeyStroke();
                KeyStroke second = ks.getSecondKeyStroke();
                if (first == null || second != null) continue;
                stroke = KeyStroke.getKeyStroke(first.getKeyCode(), first.getModifiers(), false);
                break;
            }
            if (stroke != null) {
                TimedOutCallback result = new TimedOutCallback(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Timed out calling action id=" + actionName, new Throwable(), true){

                    protected void dumpError() {
                        context.error(this.getMessage(), ActionCommand.this.getLine());
                    }
                };
                context.message("Invoking action via shortcut: " + stroke.toString(), this.getLine());
                KeyStroke finalStroke = stroke;
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable((ActionCallback)result, finalStroke){
                    final /* synthetic */ ActionCallback val$result;
                    final /* synthetic */ KeyStroke val$finalStroke;
                    {
                        this.val$result = actionCallback;
                        this.val$finalStroke = keyStroke;
                    }

                    @Override
                    public void run() {
                        final Ref listener = new Ref();
                        listener.set((Object)new AnActionListener.Adapter(){

                            public void beforeActionPerformed(final AnAction action, DataContext dataContext, AnActionEvent event) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (context.isDisposed()) {
                                            am.removeAnActionListener((AnActionListener)listener.get());
                                            return;
                                        }
                                        if (targetAction.equals(action)) {
                                            context.message("Performed action: " + actionName, context.getCurrentLine());
                                            am.removeAnActionListener((AnActionListener)listener.get());
                                            val$result.setDone();
                                        }
                                    }
                                });
                            }
                        });
                        am.addAnActionListener((AnActionListener)listener.get());
                        context.runPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                ActionCommand.this.type(context.getRobot(), val$finalStroke);
                            }
                        });
                    }
                });
                return result;
            }
        }
        final InputEvent input = ActionCommand.getInputEvent(actionName);
        final ActionCallback result = new ActionCallback();
        context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                am.tryToExecute(targetAction, input, null, null, false).doWhenProcessed(result.createSetDoneRunnable());
            }
        });
        return result;
    }

    public static InputEvent getInputEvent(String actionName) {
        Shortcut each;
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionName);
        AWTKeyStroke keyStroke = null;
        Shortcut[] arr$ = shortcuts;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (each = arr$[i$]) instanceof KeyboardShortcut && (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()) != null); ++i$) {
        }
        if (keyStroke != null) {
            return new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar(), 1);
        }
        return new MouseEvent(JOptionPane.getRootFrame(), 501, 0L, 0, 0, 0, 1, false, 1);
    }
}

