/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentEntryTreeCellRenderer
extends NodeRenderer {
    protected final ContentEntryTreeEditor myTreeEditor;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;

    public ContentEntryTreeCellRenderer(@NotNull ContentEntryTreeEditor treeEditor, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        if (treeEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeEditor", "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeCellRenderer", "<init>"));
        }
        this.myTreeEditor = treeEditor;
        this.myEditHandlers = editHandlers;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ContentEntry contentEntry;
        VirtualFile file;
        Object element;
        Object userObject;
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        ContentEntryEditor editor = this.myTreeEditor.getContentEntryEditor();
        if (editor != null && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof NodeDescriptor && (element = ((NodeDescriptor)userObject).getElement()) instanceof FileElement && (file = ((FileElement)element).getFile()) != null && file.isDirectory() && (contentEntry = editor.getContentEntry()) != null) {
            String prefix = ContentEntryTreeCellRenderer.getPrefix(contentEntry, file);
            if (!prefix.isEmpty()) {
                this.append(" (" + prefix + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
            this.setIcon(this.updateIcon(contentEntry, file, this.getIcon()));
        }
    }

    private static String getPrefix(ContentEntry entry, VirtualFile file) {
        for (SourceFolder sourceFolder : entry.getSourceFolders()) {
            if (!file.equals(sourceFolder.getFile())) continue;
            return sourceFolder.getPackagePrefix();
        }
        return "";
    }

    protected Icon updateIcon(ContentEntry entry, VirtualFile file, Icon originalIcon) {
        SourceFolder[] sourceFolders;
        for (VirtualFile excludePath : entry.getExcludeFolderFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excludePath, (VirtualFile)file, (boolean)false)) continue;
            return AllIcons.Modules.ExcludeRoot;
        }
        for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
            if (!file.equals(sourceFolder.getFile())) continue;
            return SourceRootPresentation.getSourceRootIcon(sourceFolder);
        }
        Icon icon = originalIcon;
        VirtualFile currentRoot = null;
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile sourcePath = sourceFolder.getFile();
            if (sourcePath == null || !VfsUtilCore.isAncestor((VirtualFile)sourcePath, (VirtualFile)file, (boolean)true) || currentRoot != null && VfsUtilCore.isAncestor((VirtualFile)sourcePath, currentRoot, (boolean)false)) continue;
            Icon folderIcon = this.getSourceFolderIcon(sourceFolder.getRootType());
            if (folderIcon != null) {
                icon = folderIcon;
            }
            currentRoot = sourcePath;
        }
        return icon;
    }

    @Nullable
    private Icon getSourceFolderIcon(JpsModuleSourceRootType<?> type) {
        for (ModuleSourceRootEditHandler<?> handler : this.myEditHandlers) {
            if (!handler.getRootType().equals(type)) continue;
            return handler.getFolderUnderRootIcon();
        }
        return null;
    }
}

