/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.impl.storage.FileSet;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathStorage
implements StateStorage {
    @NonNls
    public static final String SPECIAL_STORAGE = "special";
    public static final String DEFAULT_STORAGE_DESCR = ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]);
    @NonNls
    public static final String CLASSPATH_DIR_OPTION = "classpath-dir";
    @NonNls
    private static final String COMPONENT_TAG = "component";
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final TrackingPathMacroSubstitutor myTrackingPathMacroSubstitutor;

    public ClasspathStorage(@NotNull Module module, @NotNull IModuleStore moduleStore) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        if (moduleStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleStore", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        this.myConverter = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module)).createConverter(module);
        this.myTrackingPathMacroSubstitutor = moduleStore.getStateStorageManager().getMacroSubstitutor();
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class);
        if (virtualFileTracker != null) {
            SmartList files = new SmartList();
            try {
                this.myConverter.getFileSet().listFiles((List<VirtualFile>)files);
                for (VirtualFile file : files) {
                    final StateStorage.Listener listener = (StateStorage.Listener)module.getProject().getMessageBus().syncPublisher(PROJECT_STORAGE_TOPIC);
                    virtualFileTracker.addTracker(file.getUrl(), (VirtualFileListener)new VirtualFileAdapter(){

                        public void contentsChanged(@NotNull VirtualFileEvent event) {
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$1", "contentsChanged"));
                            }
                            listener.storageFileChanged(event, (StateStorage)ClasspathStorage.this);
                        }
                    }, true, (Disposable)module);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
    }

    private FileSet getFileSet() {
        return this.myConverter.getFileSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getState(Object component, @NotNull String componentName, @NotNull Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getState"));
        }
        assert (component instanceof ModuleRootManager);
        assert (componentName.equals("NewModuleRootManager"));
        assert (stateClass == ModuleRootManagerImpl.ModuleRootManagerState.class);
        try {
            Element element = new Element(COMPONENT_TAG);
            ModifiableRootModel model = null;
            try {
                model = ((ModuleRootManagerImpl)((Object)component)).getModifiableModel();
                this.myConverter.getClasspath(model, element);
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
            this.myTrackingPathMacroSubstitutor.expandPaths(element);
            this.myTrackingPathMacroSubstitutor.addUnknownMacros(componentName, PathMacrosCollector.getMacroNames(element));
            ModuleRootManagerImpl.ModuleRootManagerState moduleRootManagerState = new ModuleRootManagerImpl.ModuleRootManagerState();
            moduleRootManagerState.readExternal(element);
            return (T)moduleRootManagerState;
        }
        catch (InvalidDataException e) {
            throw new StateStorageException(e.getMessage());
        }
        catch (IOException e) {
            throw new StateStorageException(e.getMessage());
        }
    }

    public boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "hasState"));
        }
        return true;
    }

    public void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state2) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COMPONENT_TAG, "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setState"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setState"));
        }
        assert (component instanceof ModuleRootManager);
        assert (componentName.equals("NewModuleRootManager"));
        assert (state2.getClass() == ModuleRootManagerImpl.ModuleRootManagerState.class);
        try {
            this.myConverter.setClasspath((ModuleRootModel)((ModuleRootManagerImpl)((Object)component)));
        }
        catch (WriteExternalException e) {
            throw new StateStorageException(e.getMessage());
        }
        catch (IOException e) {
            throw new StateStorageException(e.getMessage());
        }
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        StateStorage.ExternalizationSession externalizationSession = new StateStorage.ExternalizationSession(){

            public void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state2, Storage storageSpec) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ClasspathStorage.COMPONENT_TAG, "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "setState"));
                }
                if (componentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "setState"));
                }
                if (state2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "setState"));
                }
                ClasspathStorage.this.setState(component, componentName, state2);
            }
        };
        if (externalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "startExternalization"));
        }
        return externalizationSession;
    }

    @Nullable
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "startSave"));
        }
        return new MySaveSession();
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> result) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
    }

    public void save() throws StateStorageException {
        final Ref ref = new Ref();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ClasspathStorage.this.getFileSet().commit();
                }
                catch (IOException e) {
                    ref.set((Object)e);
                }
            }
        });
        if (!ref.isNull()) {
            throw new StateStorageException((Throwable)ref.get());
        }
    }

    @NotNull
    public static ClasspathStorageProvider getProvider(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProvider"));
        }
        for (ClasspathStorageProvider provider : ClasspathStorage.getProviders()) {
            if (!type.equals(provider.getID())) continue;
            ClasspathStorageProvider classpathStorageProvider = provider;
            if (classpathStorageProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProvider"));
            }
            return classpathStorageProvider;
        }
        UnsupportedStorageProvider unsupportedStorageProvider = new UnsupportedStorageProvider(type);
        if (unsupportedStorageProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProvider"));
        }
        return unsupportedStorageProvider;
    }

    @NotNull
    public static List<ClasspathStorageProvider> getProviders() {
        ArrayList<ClasspathStorageProvider> list = new ArrayList<ClasspathStorageProvider>();
        list.add(new DefaultStorageProvider());
        ContainerUtil.addAll(list, (Object[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions());
        ArrayList<ClasspathStorageProvider> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProviders"));
        }
        return arrayList;
    }

    @NotNull
    public static String getModuleDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getModuleDir"));
        }
        String string = new File(module.getModuleFilePath()).getParent();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getModuleDir"));
        }
        return string;
    }

    public static String getStorageRootFromOptions(Module module) {
        String moduleRoot = ClasspathStorage.getModuleDir(module);
        String storageRef = module.getOptionValue(CLASSPATH_DIR_OPTION);
        if (storageRef == null) {
            return moduleRoot;
        }
        if (FileUtil.isAbsolute((String)storageRef)) {
            return storageRef;
        }
        return FileUtil.toSystemIndependentName((String)new File(moduleRoot, storageRef).getPath());
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageID) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        if (storageID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageID", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        Module module = model.getModule();
        String oldStorageType = ClassPathStorageUtil.getStorageType(module);
        if (oldStorageType.equals(storageID)) {
            return;
        }
        ClasspathStorage.getProvider(oldStorageType).detach(module);
        if (storageID.equals("default")) {
            module.clearOption("classpath");
            module.clearOption(CLASSPATH_DIR_OPTION);
        } else {
            module.setOption("classpath", storageID);
            module.setOption(CLASSPATH_DIR_OPTION, ClasspathStorage.getProvider(storageID).getContentRoot(model));
        }
    }

    public static void moduleRenamed(Module module, String newName) {
        ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module)).moduleRenamed(module, newName);
    }

    public static void modulePathChanged(Module module, String path) {
        ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module)).modulePathChanged(module, path);
    }

    private class MySaveSession
    implements StateStorage.SaveSession,
    SafeWriteRequestor {
        private MySaveSession() {
        }

        public void save() {
            ClasspathStorage.this.save();
        }
    }

    public static class UnsupportedStorageProvider
    implements ClasspathStorageProvider {
        private final String myType;

        public UnsupportedStorageProvider(String type) {
            this.myType = type;
        }

        @Override
        @NonNls
        public String getID() {
            return this.myType;
        }

        @Override
        @Nls
        public String getDescription() {
            return "Unsupported classpath format " + this.myType;
        }

        @Override
        public void assertCompatible(ModuleRootModel model) throws ConfigurationException {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public void detach(Module module) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public void moduleRenamed(Module module, String newName) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
            return new ClasspathStorageProvider.ClasspathConverter(){

                @Override
                public FileSet getFileSet() {
                    throw new StateStorageException(UnsupportedStorageProvider.this.getDescription());
                }

                @Override
                public Set<String> getClasspath(ModifiableRootModel model, Element element) throws InvalidDataException {
                    throw new InvalidDataException(UnsupportedStorageProvider.this.getDescription());
                }

                @Override
                public void setClasspath(ModuleRootModel model) throws WriteExternalException {
                    throw new WriteExternalException(UnsupportedStorageProvider.this.getDescription());
                }
            };
        }

        @Override
        public String getContentRoot(ModuleRootModel model) {
            return null;
        }

        @Override
        public void modulePathChanged(Module module, String path) {
            throw new UnsupportedOperationException(this.getDescription());
        }
    }

    private static class DefaultStorageProvider
    implements ClasspathStorageProvider {
        private DefaultStorageProvider() {
        }

        @Override
        @NonNls
        public String getID() {
            return "default";
        }

        @Override
        @Nls
        public String getDescription() {
            return DEFAULT_STORAGE_DESCR;
        }

        @Override
        public void assertCompatible(ModuleRootModel model) throws ConfigurationException {
        }

        @Override
        public void detach(Module module) {
        }

        @Override
        public void moduleRenamed(Module module, String newName) {
        }

        @Override
        public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
            throw new UnsupportedOperationException(this.getDescription());
        }

        @Override
        public String getContentRoot(ModuleRootModel model) {
            return null;
        }

        @Override
        public void modulePathChanged(Module module, String path) {
        }
    }
}

