/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private static final IndicatorAction CHECK_CANCELED_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$1", "execute"));
            }
            each.checkCanceled();
        }
    };
    private static final IndicatorAction STOP_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$2", "execute"));
            }
            each.stop();
        }
    };
    private static final IndicatorAction START_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$3", "execute"));
            }
            each.start();
        }
    };
    private static final IndicatorAction CANCEL_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$4", "execute"));
            }
            each.cancel();
        }
    };
    private static final IndicatorAction PUSH_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$5", "execute"));
            }
            each.pushState();
        }
    };
    private static final IndicatorAction POP_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$6", "execute"));
            }
            each.popState();
        }
    };
    private static final IndicatorAction STARTNC_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$7", "execute"));
            }
            each.startNonCancelableSection();
        }
    };
    private static final IndicatorAction FINISHNC_ACTION = new IndicatorAction(){

        @Override
        public void execute(@NotNull ProgressIndicatorEx each) {
            if (each == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$8", "execute"));
            }
            each.finishNonCancelableSection();
        }
    };
    protected final boolean myReusable;
    private volatile boolean myModalityEntered;
    private volatile List<ProgressIndicatorEx> myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            super.start();
            this.delegateRunningChange(START_ACTION);
        }
        this.myWasStarted = true;
        this.enterModality();
    }

    protected final void enterModality() {
        if (this.myModalityProgress == this) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractProgressIndicatorExBase.this.doEnterModality();
                }
            });
        }
    }

    private void doEnterModality() {
        if (!this.myModalityEntered) {
            LaterInvocator.enterModal(this);
            this.myModalityEntered = true;
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(STOP_ACTION);
        this.exitModality();
    }

    protected final void exitModality() {
        if (this.myModalityProgress == this) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractProgressIndicatorExBase.this.doExitModality();
                }
            });
        }
    }

    private void doExitModality() {
        if (this.myModalityEntered) {
            LaterInvocator.leaveModal(this);
            this.myModalityEntered = false;
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(CANCEL_ACTION);
    }

    @Override
    public boolean isCanceled() {
        return super.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(final @NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "finish"));
        }
        WeakList finished = this.myFinished;
        if (finished == null) {
            AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
            synchronized (abstractProgressIndicatorExBase) {
                finished = this.myFinished;
                if (finished == null) {
                    this.myFinished = finished = new WeakList();
                }
            }
        }
        if (!finished.addIfAbsent((Object)task)) {
            return;
        }
        this.delegateRunningChange(new IndicatorAction(){

            @Override
            public void execute(@NotNull ProgressIndicatorEx each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$11", "execute"));
                }
                each.finish(task);
            }
        });
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "isFinished"));
        }
        WeakList<TaskInfo> list = this.myFinished;
        return list != null && list.contains(task);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(CHECK_CANCELED_ACTION);
    }

    @Override
    public void setText(final String text) {
        super.setText(text);
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(@NotNull ProgressIndicatorEx each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$12", "execute"));
                }
                each.setText(text);
            }
        });
    }

    @Override
    public void setText2(final String text) {
        super.setText2(text);
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(@NotNull ProgressIndicatorEx each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$13", "execute"));
                }
                each.setText2(text);
            }
        });
    }

    @Override
    public void setFraction(final double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(@NotNull ProgressIndicatorEx each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$14", "execute"));
                }
                each.setFraction(fraction);
            }
        });
    }

    @Override
    public synchronized void pushState() {
        super.pushState();
        this.delegateProgressChange(PUSH_ACTION);
    }

    @Override
    public synchronized void popState() {
        super.popState();
        this.delegateProgressChange(POP_ACTION);
    }

    @Override
    public void startNonCancelableSection() {
        super.startNonCancelableSection();
        this.delegateProgressChange(STARTNC_ACTION);
    }

    @Override
    public void finishNonCancelableSection() {
        super.finishNonCancelableSection();
        this.delegateProgressChange(FINISHNC_ACTION);
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(final boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(new IndicatorAction(){

            @Override
            public void execute(@NotNull ProgressIndicatorEx each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase$15", "execute"));
                }
                each.setIndeterminate(indeterminate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "addStateDelegate"));
        }
        delegate.initStateFrom(this);
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            List stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = stateDelegates = ContainerUtil.createLockFreeCopyOnWriteList();
            } else {
                LOG.assertTrue(!stateDelegates.contains(delegate), (Object)("Already registered: " + delegate));
            }
            stateDelegates.add(delegate);
        }
    }

    private void delegateProgressChange(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegateProgressChange"));
        }
        this.delegate(action);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegateRunningChange"));
        }
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegate"));
        }
        List<ProgressIndicatorEx> list = this.myStateDelegates;
        if (list != null && !list.isEmpty()) {
            for (ProgressIndicatorEx each : list) {
                action.execute(each);
            }
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean isModalityEntered() {
        return this.myModalityEntered;
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "initStateFrom"));
        }
        super.initStateFrom(indicator);
        if (indicator instanceof ProgressIndicatorEx) {
            this.myModalityEntered = ((ProgressIndicatorEx)indicator).isModalityEntered();
        }
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

