/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PlusMinus;
import java.util.HashMap;
import java.util.Map;

public class BackgroundTasksMonitor
implements PlusMinus<String> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.BackgroundTasksMonitor");
    private static final long ourStatInterval = 300000L;
    private long myRecentTime;
    private final Map<String, Integer> myMap;
    private final Map<String, Integer> myMaxMap;
    private final Object myLock;
    private final String myQueueTitle;

    public BackgroundTasksMonitor(String queueTitle) {
        this.myQueueTitle = queueTitle;
        this.myMap = new HashMap<String, Integer>();
        this.myMaxMap = new HashMap<String, Integer>();
        this.myLock = new Object();
        this.myRecentTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plus(String title) {
        Object object = this.myLock;
        synchronized (object) {
            Integer previous = this.myMap.get(title);
            int newVal = previous == null ? 1 : previous + 1;
            this.myMap.put(title, newVal);
            Integer max = this.myMaxMap.get(title);
            if (max == null || max < newVal) {
                this.myMaxMap.put(title, newVal);
            }
            this.reportStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minus(String title) {
        Object object = this.myLock;
        synchronized (object) {
            Integer integer = this.myMap.get(title);
            assert (integer != null);
            if (integer == 1) {
                this.myMap.remove(title);
            } else {
                this.myMap.put(title, integer - 1);
            }
            this.reportStatistics();
        }
    }

    private void reportStatistics() {
        long time = System.currentTimeMillis();
        if (time - 300000L < this.myRecentTime) {
            return;
        }
        StringBuilder sb = new StringBuilder("BackgroundTaskQueue '" + this.myQueueTitle + "' usage statistics\n");
        sb.append("----------------------------------------------------\n");
        sb.append("Current Values:");
        for (Map.Entry<String, Integer> entry : this.myMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\nMaximum Values:");
        for (Map.Entry<String, Integer> entry : this.myMaxMap.entrySet()) {
            sb.append('\n').append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("----------------------------------------------------\n");
        LOG.info(sb.toString());
        this.myRecentTime = time;
    }
}

