/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewInfo;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewManagerImpl
implements PreviewManager {
    private static final Key<PreviewInfo> INFO_KEY = Key.create((String)"preview_info");
    private static final int HISTORY_LIMIT = 10;
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private ToolWindowImpl myToolWindow;
    private ContentManager myContentManager;
    private Content myEmptyStateContent;
    private final JPanel myEmptyStatePanel;
    private ArrayList<PreviewInfo> myHistory = new ArrayList();
    private TreeSet<PreviewPanelProvider> myProviders = new TreeSet<PreviewPanelProvider>(new Comparator<PreviewPanelProvider>(){

        @Override
        public int compare(PreviewPanelProvider o1, PreviewPanelProvider o2) {
            return Float.compare(o1.getMenuOrder(), o2.getMenuOrder());
        }
    });
    private Set<PreviewProviderId> myActiveProviderIds = new HashSet<PreviewProviderId>();
    private boolean myInnerSelectionChange;

    private static boolean isAvailable() {
        return UISettings.getInstance().NAVIGATE_TO_PREVIEW;
    }

    public PreviewManagerImpl(Project project) {
        PreviewPanelProvider[] providers;
        this.myProject = project;
        this.myEmptyStatePanel = new EmptyStatePanel();
        for (PreviewPanelProvider provider : providers = (PreviewPanelProvider[])PreviewPanelProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            this.myProviders.add(provider);
            if (!provider.shouldBeEnabledByDefault()) continue;
            this.myActiveProviderIds.add(provider.getId());
        }
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                PreviewManagerImpl.this.checkGlobalState();
            }
        }, (Disposable)this.myProject);
        this.checkGlobalState();
        this.checkEmptyState();
    }

    @Nullable
    public <V, C> PreviewPanelProvider<V, C> findProvider(@NotNull PreviewProviderId<V, C> id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "findProvider"));
        }
        for (PreviewPanelProvider provider : this.myProviders) {
            if (id != provider.getId()) continue;
            return provider;
        }
        return null;
    }

    protected void checkGlobalState() {
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)this.myProject);
        if (!PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow(ToolWindowId.PREVIEW) != null) {
            this.myHistory.clear();
            this.myContentManager.removeAllContents(true);
            toolWindowManager.unregisterToolWindow(ToolWindowId.PREVIEW);
            return;
        }
        if (PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow(ToolWindowId.PREVIEW) == null) {
            this.myToolWindow = (ToolWindowImpl)toolWindowManager.registerToolWindow(ToolWindowId.PREVIEW, this.myEmptyStatePanel, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, false);
            this.myContentManager = this.myToolWindow.getContentManager();
            this.myToolWindow.setIcon(AllIcons.Actions.PreviewDetails);
            this.myToolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
            this.myToolWindow.setAutoHide(true);
            this.myEmptyStateContent = this.myContentManager.getContent(0);
            this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    if (PreviewManagerImpl.this.myInnerSelectionChange || event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                        return;
                    }
                    PreviewInfo previewInfo = (PreviewInfo)event.getContent().getUserData(INFO_KEY);
                    if (previewInfo != null) {
                        PreviewManagerImpl.this.preview(previewInfo, true);
                    }
                }
            });
            MoveToStandardViewAction moveToStandardViewAction = new MoveToStandardViewAction();
            moveToStandardViewAction.registerCustomShortcutSet(new ShortcutSet(){

                @NotNull
                public Shortcut[] getShortcuts() {
                    Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
                    Shortcut[] shortcutArray = keymap.getShortcuts("ShowContent");
                    if (shortcutArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/impl/PreviewManagerImpl$4", "getShortcuts"));
                    }
                    return shortcutArray;
                }
            }, this.myToolWindow.getComponent());
            this.myToolWindow.setTitleActions(moveToStandardViewAction);
            ArrayList<ContentTypeToggleAction> myGearActions = new ArrayList<ContentTypeToggleAction>();
            for (PreviewPanelProvider provider : this.myProviders) {
                myGearActions.add(new ContentTypeToggleAction(provider));
            }
            this.myToolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup("Preview", myGearActions));
        }
    }

    private void checkEmptyState() {
        if (this.myContentManager.getContents().length == 0) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "false");
            this.myContentManager.addContent(this.myEmptyStateContent);
        } else if (this.myContentManager.getContents().length > 1) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            this.myContentManager.removeContent(this.myEmptyStateContent, false);
        }
    }

    @Nullable
    private Content getContent(@NotNull PreviewInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "getContent"));
        }
        for (Content content : this.myContentManager.getContents()) {
            if (!info.equals(content.getUserData(INFO_KEY))) continue;
            return content;
        }
        return null;
    }

    @NotNull
    private Content addContent(PreviewInfo info) {
        this.myHistory.add(info);
        while (this.myHistory.size() > 10) {
            PreviewInfo previewInfo = this.myHistory.remove(0);
            this.close(previewInfo);
        }
        Content content = this.myContentManager.getFactory().createContent(info.getComponent(), info.getTitle(), false);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.putUserData(INFO_KEY, (Object)info);
        content.setIcon(info.getIcon());
        content.setPopupIcon(info.getIcon());
        this.myContentManager.addContent(content, 0);
        this.checkEmptyState();
        Content content2 = content;
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "addContent"));
        }
        return content2;
    }

    private void close(@NotNull PreviewInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "close"));
        }
        Content content = this.getContent(info);
        if (content != null) {
            this.myContentManager.removeContent(content, false);
            if (this.myContentManager.getContents().length == 0) {
                this.toggleToolWindow(false);
            }
            this.checkEmptyState();
        }
    }

    @Override
    public <V, C> C preview(@NotNull PreviewProviderId<V, C> id, V data, boolean requestFocus) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "preview"));
        }
        PreviewPanelProvider<V, C> provider = this.findProvider(id);
        if (provider == null || !this.myActiveProviderIds.contains(id)) {
            return null;
        }
        return this.preview(PreviewInfo.create(provider, data), requestFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, C> C preview(@NotNull PreviewInfo<V, C> info, boolean requestFocus) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "preview"));
        }
        this.toggleToolWindow(true);
        Content content = this.getContent(info);
        if (this.myContentManager.getSelectedContent() != content) {
            this.myInnerSelectionChange = true;
            try {
                if (content == null) {
                    content = this.addContent(info);
                }
                this.myContentManager.setSelectedContent(content);
            }
            finally {
                this.myInnerSelectionChange = false;
            }
        }
        if (content != null) {
            this.myContentManager.addContent(content, 0);
        }
        return info.initComponent(requestFocus);
    }

    @Override
    public <V, C> void close(@NotNull PreviewProviderId<V, C> id, V data) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "close"));
        }
        for (Content content : this.myContentManager.getContents()) {
            PreviewInfo info = (PreviewInfo)content.getUserData(INFO_KEY);
            if (info == null || info.getId() != id || info.getData() != data) continue;
            this.close(info);
            break;
        }
    }

    @Override
    public <V, C> boolean moveToStandardPlace(@NotNull PreviewProviderId<V, C> id, V data) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/preview/impl/PreviewManagerImpl", "moveToStandardPlace"));
        }
        PreviewPanelProvider<V, C> provider = this.findProvider(id);
        if (provider != null && provider.moveContentToStandardView(data)) {
            this.close(id, data);
            return true;
        }
        return false;
    }

    private void toggleToolWindow(boolean activate) {
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PREVIEW);
        if (toolWindow != null && activate != toolWindow.isActive()) {
            if (activate) {
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        toolWindow.activate(null, false);
                    }
                }, 75, ModalityState.stateForComponent((Component)this.myEmptyStatePanel));
            } else if (!this.myAlarm.isEmpty()) {
                toolWindow.hide(null);
            }
        }
    }

    private static class EmptyStatePanel
    extends JPanel {
        public EmptyStatePanel() {
            this.setOpaque(true);
        }

        @Override
        public void paint(Graphics g) {
            boolean isDarkBackground = UIUtil.isUnderDarcula();
            UIUtil.applyRenderingHints((Graphics)g);
            GraphicsUtil.setupAntialiasing((Graphics)g, (boolean)true, (boolean)false);
            g.setColor((Color)new JBColor((Color)(isDarkBackground ? Gray._230 : Gray._80), (Color)Gray._160));
            g.setFont(UIUtil.getLabelFont().deriveFont(isDarkBackground ? 24.0f : 20.0f));
            UIUtil.TextPainter painter = new UIUtil.TextPainter().withLineSpacing(1.5f);
            painter.withShadow(true, (Color)new JBColor(Gray._200.withAlpha(100), Gray._0.withAlpha(255)));
            painter.appendLine("No files are open");
            painter.draw(g, (PairFunction)new PairFunction<Integer, Integer, Couple<Integer>>(){

                public Couple<Integer> fun(Integer width, Integer height) {
                    Dimension s = EmptyStatePanel.this.getSize();
                    return Couple.of((Object)((s.width - width) / 2), (Object)((s.height - height) / 2));
                }
            });
        }
    }

    private class ContentTypeToggleAction
    extends ToggleAction {
        private final PreviewPanelProvider myProvider;

        ContentTypeToggleAction(PreviewPanelProvider provider) {
            super(provider.getId().getVisualName());
            this.myProvider = provider;
        }

        public boolean isSelected(AnActionEvent e) {
            return PreviewManagerImpl.this.myActiveProviderIds.contains(this.myProvider.getId());
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                PreviewManagerImpl.this.myActiveProviderIds.add(this.myProvider.getId());
            } else {
                PreviewManagerImpl.this.myActiveProviderIds.remove(this.myProvider.getId());
                Iterator iterator = PreviewManagerImpl.this.myHistory.iterator();
                while (iterator.hasNext()) {
                    PreviewInfo info = (PreviewInfo)iterator.next();
                    if (!info.getId().equals(this.myProvider.getId())) continue;
                    Content content = PreviewManagerImpl.this.getContent(info);
                    if (content != null) {
                        PreviewManagerImpl.this.myContentManager.removeContent(content, true);
                    }
                    iterator.remove();
                }
                PreviewManagerImpl.this.checkEmptyState();
            }
        }
    }

    private class MoveToStandardViewAction
    extends AnAction {
        public MoveToStandardViewAction() {
            super("Move to standard view", "Move to standard view", AllIcons.Duplicates.SendToTheLeftGrayed);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/preview/impl/PreviewManagerImpl$MoveToStandardViewAction", "actionPerformed"));
            }
            Content selectedContent = PreviewManagerImpl.this.myContentManager.getSelectedContent();
            if (selectedContent == null) {
                return;
            }
            PreviewInfo previewInfo = (PreviewInfo)selectedContent.getUserData(INFO_KEY);
            if (previewInfo != null) {
                PreviewManagerImpl.this.moveToStandardPlace(previewInfo.getId(), previewInfo.getData());
                PreviewManagerImpl.this.toggleToolWindow(false);
            }
        }
    }
}

