/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SettingsTreeView
extends JComponent
implements Disposable,
OptionsEditorColleague {
    private static final String NODE_ICON = "settings.tree.view.icon";
    private static final Color NORMAL_NODE = new JBColor((Color)Gray._60, (Color)Gray._140);
    private static final Color WRONG_CONTENT = JBColor.RED;
    private static final Color MODIFIED_CONTENT = JBColor.BLUE;
    final SimpleTree myTree;
    final FilteringTreeBuilder myBuilder;
    private final SettingsFilter myFilter;
    private final MyRoot myRoot;
    private final JScrollPane myScroller;
    private JLabel mySeparator;
    private final IdentityHashMap<Configurable, MyNode> myConfigurableToNodeMap = new IdentityHashMap();
    private final IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper> myConfigurableToWrapperMap = new IdentityHashMap();
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("SettingsTreeView", 150, false, (JComponent)this, (Disposable)this, (JComponent)this).setRestartTimerOnAdd(true);
    private Configurable myQueuedConfigurable;

    SettingsTreeView(SettingsFilter filter, ConfigurableGroup ... groups) {
        this.myFilter = filter;
        this.myRoot = new MyRoot(groups);
        this.myTree = new MyTree();
        this.myTree.putClientProperty((Object)"TreeTableTree", (Object)Boolean.TRUE);
        this.myTree.setBackground(UIUtil.getSidePanelColor());
        this.myTree.getInputMap().clear();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setOpaque(true);
        this.myTree.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyRenderer());
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setExpandableItemsEnabled(false);
        this.myScroller = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
        this.myScroller.getVerticalScrollBar().setUI(ButtonlessScrollBarUI.createTransparent());
        this.myScroller.setBackground(UIUtil.getSidePanelColor());
        this.myScroller.getViewport().setBackground(UIUtil.getSidePanelColor());
        this.myScroller.getVerticalScrollBar().setBackground(UIUtil.getSidePanelColor());
        this.add(this.myScroller);
        this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                MyNode node = SettingsTreeView.extractNode(event.getNewLeadSelectionPath());
                SettingsTreeView.this.select(node == null ? null : node.myConfigurable);
            }
        });
        this.myBuilder = new MyBuilder((SimpleTreeStructure)new SimpleTreeStructure.Impl((SimpleNode)this.myRoot));
        this.myBuilder.setFilteringMerge(300, null);
        this.setMinimumSize(new Dimension(200, 100));
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
    }

    @NotNull
    String[] getPathNames(Configurable configurable) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        MyNode node = this.findNode(configurable);
        while (node != null) {
            path.push(node.myDisplayName);
            SimpleNode parent = node.getParent();
            node = parent instanceof MyNode ? (MyNode)parent : null;
        }
        String[] stringArray = ArrayUtil.toStringArray(path);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsTreeView", "getPathNames"));
        }
        return stringArray;
    }

    static Configurable getConfigurable(SimpleNode node) {
        return node instanceof MyNode ? ((MyNode)node).myConfigurable : null;
    }

    @Nullable
    MyNode findNode(Configurable configurable) {
        ConfigurableWrapper wrapper = this.myConfigurableToWrapperMap.get(configurable);
        return this.myConfigurableToNodeMap.get(wrapper != null ? wrapper : configurable);
    }

    @Nullable
    SearchableConfigurable findConfigurableById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/newEditor/SettingsTreeView", "findConfigurableById"));
        }
        for (Configurable configurable : this.myConfigurableToNodeMap.keySet()) {
            SearchableConfigurable searchable;
            if (!(configurable instanceof SearchableConfigurable) || !id.equals((searchable = (SearchableConfigurable)configurable).getId())) continue;
            return searchable;
        }
        return null;
    }

    @Nullable
    <T extends UnnamedConfigurable> T findConfigurable(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/newEditor/SettingsTreeView", "findConfigurable"));
        }
        for (Configurable configurable : this.myConfigurableToNodeMap.keySet()) {
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                configurable = wrapper.getConfigurable();
                this.myConfigurableToWrapperMap.put((UnnamedConfigurable)configurable, wrapper);
            }
            if (!type.isInstance(configurable)) continue;
            return (T)((UnnamedConfigurable)type.cast(configurable));
        }
        return null;
    }

    @Nullable
    Project findConfigurableProject(@Nullable Configurable configurable) {
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            return wrapper.getExtensionPoint().getProject();
        }
        return SettingsTreeView.findConfigurableProject(this.findNode(configurable));
    }

    @Nullable
    private static Project findConfigurableProject(@Nullable MyNode node) {
        if (node != null) {
            Configurable configurable = node.myConfigurable;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                return wrapper.getExtensionPoint().getProject();
            }
            SimpleNode parent = node.getParent();
            if (parent instanceof MyNode) {
                return SettingsTreeView.findConfigurableProject((MyNode)parent);
            }
        }
        return null;
    }

    @Nullable
    private String findGroupNameAt(int x, int y) {
        for (TreePath path = this.myTree.getClosestPathForLocation(x - this.myTree.getX(), y - this.myTree.getY()); path != null; path = path.getParentPath()) {
            MyNode node = SettingsTreeView.extractNode(path);
            if (node == null) {
                return null;
            }
            if (this.myRoot != node.getParent()) continue;
            return node.myDisplayName;
        }
        return null;
    }

    @Nullable
    private static MyNode extractNode(@Nullable Object object) {
        DefaultMutableTreeNode node;
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            object = path.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            node = (FilteringTreeStructure.FilteringNode)object;
            object = node.getDelegate();
        }
        return object instanceof MyNode ? (MyNode)((Object)object) : null;
    }

    @Override
    public void doLayout() {
        this.myScroller.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        int height;
        String group;
        super.paint(g);
        if (0 == this.myTree.getY()) {
            return;
        }
        if (this.mySeparator == null) {
            this.mySeparator = new JLabel();
            this.mySeparator.setForeground(NORMAL_NODE);
            this.mySeparator.setFont(UIUtil.getLabelFont());
            this.mySeparator.setFont(this.getFont().deriveFont(1));
        }
        if ((group = this.findGroupNameAt(0, height = this.mySeparator.getPreferredSize().height)) != null && group.equals(this.findGroupNameAt(0, 0))) {
            this.mySeparator.setBorder(BorderFactory.createEmptyBorder(1, 22, 0, 0));
            this.mySeparator.setText(group);
            Rectangle bounds = this.myScroller.getViewport().getBounds();
            if (bounds.height > height) {
                bounds.height = height;
            }
            g.setColor(this.myTree.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            if (g instanceof Graphics2D) {
                int h = 6;
                int y = bounds.y + bounds.height;
                ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)y, (Color)g.getColor(), (float)0.0f, (float)(y + h), (Color)ColorUtil.toAlpha((Color)g.getColor(), (int)0)));
                g.fillRect(bounds.x, y, bounds.width, h);
            }
            this.mySeparator.setSize(bounds.width - 1, bounds.height);
            this.mySeparator.paint(g.create(bounds.x + 1, bounds.y, bounds.width - 1, bounds.height));
        }
    }

    void selectFirst() {
        for (ConfigurableGroup eachGroup : this.myRoot.myGroups) {
            Configurable[] kids = eachGroup.getConfigurables();
            if (kids.length <= 0) continue;
            this.select(kids[0]);
            return;
        }
    }

    ActionCallback select(final @Nullable Configurable configurable) {
        if (this.myBuilder.isSelectionBeingAdjusted()) {
            return new ActionCallback.Rejected();
        }
        final ActionCallback callback = new ActionCallback();
        this.myQueuedConfigurable = configurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                if (configurable == SettingsTreeView.this.myQueuedConfigurable) {
                    if (configurable == null) {
                        SettingsTreeView.this.fireSelected(null, callback);
                    } else {
                        SettingsTreeView.this.myBuilder.getReady((Object)this).doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                if (configurable != SettingsTreeView.this.myQueuedConfigurable) {
                                    return;
                                }
                                MyNode editorNode = SettingsTreeView.this.findNode(configurable);
                                FilteringTreeStructure.FilteringNode editorUiNode = SettingsTreeView.this.myBuilder.getVisibleNodeFor((Object)editorNode);
                                if (editorUiNode == null) {
                                    return;
                                }
                                if (!SettingsTreeView.this.myBuilder.getSelectedElements().contains(editorUiNode)) {
                                    SettingsTreeView.this.myBuilder.select((Object)editorUiNode, new Runnable(){

                                        @Override
                                        public void run() {
                                            SettingsTreeView.this.fireSelected(configurable, callback);
                                        }
                                    });
                                } else {
                                    SettingsTreeView.this.myBuilder.scrollSelectionToVisible(new Runnable(){

                                        @Override
                                        public void run() {
                                            SettingsTreeView.this.fireSelected(configurable, callback);
                                        }
                                    }, false);
                                }
                            }
                        });
                    }
                }
            }

            public void setRejected() {
                super.setRejected();
                callback.setRejected();
            }
        });
        return callback;
    }

    private void fireSelected(Configurable configurable, ActionCallback callback) {
        ConfigurableWrapper wrapper = this.myConfigurableToWrapperMap.get(configurable);
        this.myFilter.myContext.fireSelected((Configurable)(wrapper != null ? wrapper : configurable), this).doWhenProcessed(callback.createSetDoneRunnable());
    }

    public void dispose() {
        this.myQueuedConfigurable = null;
    }

    @Override
    public ActionCallback onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
        return this.select(configurable);
    }

    @Override
    public ActionCallback onModifiedAdded(Configurable configurable) {
        this.myTree.repaint();
        return new ActionCallback.Done();
    }

    @Override
    public ActionCallback onModifiedRemoved(Configurable configurable) {
        this.myTree.repaint();
        return new ActionCallback.Done();
    }

    @Override
    public ActionCallback onErrorsChanged() {
        return new ActionCallback.Done();
    }

    private final class MyBuilder
    extends FilteringTreeBuilder {
        List<Object> myToExpandOnResetFilter;
        boolean myRefilteringNow;
        boolean myWasHoldingFilter;

        public MyBuilder(SimpleTreeStructure structure) {
            super((Tree)SettingsTreeView.this.myTree, (ElementFilter)SettingsTreeView.this.myFilter, (AbstractTreeStructure)structure, null);
            SettingsTreeView.this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }
            });
        }

        private void invalidateExpansions() {
            if (!this.myRefilteringNow) {
                this.myToExpandOnResetFilter = null;
            }
        }

        protected boolean isSelectable(Object object) {
            return object instanceof MyNode;
        }

        public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
            return ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter();
        }

        public boolean isToEnsureSelectionOnFocusGained() {
            return false;
        }

        protected ActionCallback refilterNow(Object preferredSelection, boolean adjustSelection) {
            final ArrayList<Object> toRestore = new ArrayList<Object>();
            if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && !this.myWasHoldingFilter && this.myToExpandOnResetFilter == null) {
                this.myToExpandOnResetFilter = SettingsTreeView.this.myBuilder.getUi().getExpandedElements();
            } else if (!((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && this.myWasHoldingFilter && this.myToExpandOnResetFilter != null) {
                toRestore.addAll(this.myToExpandOnResetFilter);
                this.myToExpandOnResetFilter = null;
            }
            this.myWasHoldingFilter = ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter();
            ActionCallback result = super.refilterNow(preferredSelection, adjustSelection);
            this.myRefilteringNow = true;
            return result.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    MyBuilder.this.myRefilteringNow = false;
                    if (!((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && MyBuilder.this.getSelectedElements().isEmpty()) {
                        MyBuilder.this.restoreExpandedState(toRestore);
                    }
                }
            });
        }

        private void restoreExpandedState(List<Object> toRestore) {
            TreePath[] selected = SettingsTreeView.this.myTree.getSelectionPaths();
            if (selected == null) {
                selected = new TreePath[]{};
            }
            ArrayList<TreePath> toCollapse = new ArrayList<TreePath>();
            for (int eachRow = 0; eachRow < SettingsTreeView.this.myTree.getRowCount(); ++eachRow) {
                Object eachElement;
                TreePath eachVisiblePath;
                if (!SettingsTreeView.this.myTree.isExpanded(eachRow) || (eachVisiblePath = SettingsTreeView.this.myTree.getPathForRow(eachRow)) == null || toRestore.contains(eachElement = SettingsTreeView.this.myBuilder.getElementFor(eachVisiblePath.getLastPathComponent()))) continue;
                for (TreePath eachSelected : selected) {
                    if (eachVisiblePath.isDescendant(eachSelected)) continue;
                    toCollapse.add(eachVisiblePath);
                }
            }
            for (TreePath each : toCollapse) {
                SettingsTreeView.this.myTree.collapsePath(each);
            }
        }
    }

    private static final class MyTreeUi
    extends WideSelectionTreeUI {
        private MyTreeUi() {
        }

        boolean processMouseEvent(MouseEvent event) {
            if (this.tree instanceof SimpleTree) {
                Component component;
                boolean toggleNow;
                SimpleTree tree = (SimpleTree)this.tree;
                boolean bl = toggleNow = 502 == event.getID() && UIUtil.isActionClick((MouseEvent)event, (int)502) && !this.isToggleEvent(event);
                if ((toggleNow || 501 == event.getID()) && (component = tree.getDeepestRendererComponentAt(event.getX(), event.getY())) != null && SettingsTreeView.NODE_ICON.equals(component.getName())) {
                    if (toggleNow) {
                        this.toggleExpandState(tree.getPathForLocation(event.getX(), event.getY()));
                    }
                    event.consume();
                    return true;
                }
            }
            return false;
        }

        protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            return false;
        }

        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        public void paint(Graphics g, JComponent c) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paint(g, c);
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (this.tree != null) {
                int width = this.tree.getWidth();
                Container parent = this.tree.getParent();
                if (parent instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    width = viewport.getWidth() - viewport.getViewPosition().x;
                }
                if (bounds.width < (width -= bounds.x)) {
                    bounds.width = width;
                }
            }
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private final class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public String getToolTipText(MouseEvent event) {
            String text;
            JLabel label;
            Component component;
            if (event != null && (component = this.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && (label = (JLabel)component).getIcon() != null && (text = label.getToolTipText()) != null) {
                return text;
            }
            return super.getToolTipText(event);
        }

        protected boolean paintNodes() {
            return false;
        }

        protected boolean highlightSingleNode() {
            return false;
        }

        public void setUI(TreeUI ui) {
            super.setUI((TreeUI)(ui instanceof MyTreeUi ? ui : new MyTreeUi()));
        }

        protected boolean isCustomUI() {
            return true;
        }

        protected void configureUiHelper(TreeUIHelper helper) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public void processKeyEvent(KeyEvent e) {
            TreePath path = SettingsTreeView.this.myTree.getSelectionPath();
            if (path != null) {
                if (e.getKeyCode() == 37) {
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                        return;
                    }
                } else if (e.getKeyCode() == 39 && this.isCollapsed(path)) {
                    this.expandPath(path);
                    return;
                }
            }
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent event) {
            MyTreeUi ui = (MyTreeUi)((Object)SettingsTreeView.this.myTree.getUI());
            if (!ui.processMouseEvent(event)) {
                super.processMouseEvent(event);
            }
        }
    }

    private final class MyRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final JLabel myTextLabel;
        private final JLabel myNodeIcon;
        private final JLabel myProjectIcon;

        public MyRenderer() {
            super(new BorderLayout());
            this.myTextLabel = new ErrorLabel();
            this.myNodeIcon = new JLabel(" ", 4);
            this.myProjectIcon = new JLabel(" ", 2);
            this.myNodeIcon.setName(SettingsTreeView.NODE_ICON);
            this.add("Center", this.myTextLabel);
            this.add("West", this.myNodeIcon);
            this.add("East", this.myProjectIcon);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
            SimpleNode parent;
            Configurable configurable;
            this.myTextLabel.setFont(UIUtil.getLabelFont());
            this.setPreferredSize(null);
            MyNode node = SettingsTreeView.extractNode(value);
            if (node == null) {
                this.myTextLabel.setText(value.toString());
            } else {
                this.myTextLabel.setText(node.myDisplayName);
                if (SettingsTreeView.this.myRoot == node.getParent()) {
                    this.myTextLabel.setFont(this.myTextLabel.getFont().deriveFont(1));
                }
                if (tree.isVisible()) {
                    int visibleWidth;
                    int indent = node.myLevel * (UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent());
                    Insets treeInsets = tree.getInsets();
                    if (treeInsets != null) {
                        indent += treeInsets.left + treeInsets.right;
                    }
                    if ((visibleWidth = tree.getVisibleRect().width) > indent) {
                        Dimension size = this.getPreferredSize();
                        size.width = visibleWidth - indent;
                    }
                }
            }
            this.myTextLabel.setForeground(selected ? UIUtil.getTreeSelectionForeground() : NORMAL_NODE);
            if (!selected && node != null && (configurable = node.myConfigurable) != null) {
                if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.getErrors().containsKey(configurable)) {
                    this.myTextLabel.setForeground(WRONG_CONTENT);
                } else if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.getModified().contains(configurable)) {
                    this.myTextLabel.setForeground(MODIFIED_CONTENT);
                }
            }
            Project project = null;
            if (node != null && (parent = node.getParent()) instanceof MyNode) {
                if (SettingsTreeView.this.myRoot == parent.getParent()) {
                    Configurable[] configurables;
                    project = SettingsTreeView.findConfigurableProject(node);
                    if (node.myConfigurable instanceof SortedConfigurableGroup && (configurables = ((SortedConfigurableGroup)node.myConfigurable).getConfigurables()) != null) {
                        project = SettingsTreeView.this.findConfigurableProject(configurables[0]);
                    }
                } else if (((MyNode)parent).myConfigurable instanceof SortedConfigurableGroup && ((MyNode)node.getParent()).myConfigurable instanceof SortedConfigurableGroup) {
                    project = SettingsTreeView.findConfigurableProject(node);
                }
            }
            if (project != null) {
                this.myProjectIcon.setIcon(selected ? AllIcons.General.ProjectConfigurableSelected : AllIcons.General.ProjectConfigurable);
                this.myProjectIcon.setToolTipText(OptionsBundle.message((String)(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
                this.myProjectIcon.setVisible(true);
            } else {
                this.myProjectIcon.setVisible(false);
            }
            Icon nodeIcon = null;
            if (node != null) {
                if (0 == node.getChildCount()) {
                    nodeIcon = SettingsTreeView.this.myTree.getEmptyHandle();
                } else if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                    nodeIcon = SettingsTreeView.this.myTree.isExpanded(new TreePath(treeNode.getPath())) ? SettingsTreeView.this.myTree.getExpandedHandle() : SettingsTreeView.this.myTree.getCollapsedHandle();
                }
            }
            this.myNodeIcon.setIcon(nodeIcon);
            return this;
        }
    }

    private final class MyNode
    extends CachingSimpleNode {
        private final Configurable.Composite myComposite;
        private final Configurable myConfigurable;
        private final String myDisplayName;
        private final int myLevel;

        private MyNode(CachingSimpleNode parent, Configurable configurable, int level) {
            super((SimpleNode)parent);
            this.myComposite = configurable instanceof Configurable.Composite ? (Configurable.Composite)configurable : null;
            this.myConfigurable = configurable;
            String name = configurable.getDisplayName();
            this.myDisplayName = name != null ? name.replace("\n", " ") : "{ " + configurable.getClass().getSimpleName() + " }";
            this.myLevel = level;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myConfigurable != null) {
                SettingsTreeView.this.myConfigurableToNodeMap.put(this.myConfigurable, this);
            }
            if (this.myComposite == null) {
                return NO_CHILDREN;
            }
            Configurable[] configurables = this.myComposite.getConfigurables();
            if (configurables == null || configurables.length == 0) {
                return NO_CHILDREN;
            }
            SimpleNode[] result = new SimpleNode[configurables.length];
            for (int i = 0; i < configurables.length; ++i) {
                result[i] = new MyNode(this, configurables[i], this.myLevel + 1);
                if (this.myConfigurable == null) continue;
                ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.registerKid(this.myConfigurable, configurables[i]);
            }
            return result;
        }

        public boolean isAlwaysLeaf() {
            return this.myComposite == null;
        }
    }

    private final class MyRoot
    extends CachingSimpleNode {
        private final ConfigurableGroup[] myGroups;

        private MyRoot(ConfigurableGroup[] groups) {
            super(null);
            this.myGroups = groups;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myGroups == null || this.myGroups.length == 0) {
                return NO_CHILDREN;
            }
            ArrayList<MyNode> list = new ArrayList<MyNode>();
            for (ConfigurableGroup group : this.myGroups) {
                for (Configurable configurable : group.getConfigurables()) {
                    list.add(new MyNode(this, configurable, 0));
                }
            }
            return list.toArray(new SimpleNode[list.size()]);
        }
    }
}

