/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SortedConfigurableGroup
extends SearchableConfigurable.Parent.Abstract
implements SearchableConfigurable,
ConfigurableGroup,
Configurable.NoScroll {
    private final ArrayList<WeightConfigurable> myList = new ArrayList();
    private final String myGroupId;
    private String myDisplayName;

    private SortedConfigurableGroup(String groupId) {
        this.myGroupId = groupId;
    }

    public SortedConfigurableGroup(Project project, Configurable ... configurables) {
        this.myGroupId = "root";
        HashMap<String, SortedConfigurableGroup> map = new HashMap<String, SortedConfigurableGroup>();
        map.put(this.myGroupId, this);
        for (Configurable configurable : configurables) {
            SortedConfigurableGroup composite;
            int weight = 0;
            String groupId = null;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                weight = wrapper.getExtensionPoint().groupWeight;
                groupId = wrapper.getExtensionPoint().groupId;
            }
            if ((composite = (SortedConfigurableGroup)((Object)map.get(groupId))) == null) {
                composite = new SortedConfigurableGroup(groupId);
                map.put(groupId, composite);
            }
            composite.add(weight, configurable);
        }
        this.add(70, (Configurable)map.remove("appearance"));
        this.add(60, (Configurable)map.remove("editor"));
        SortedConfigurableGroup projectGroup = (SortedConfigurableGroup)((Object)map.remove("project"));
        if (projectGroup != null && project != null && !project.isDefault()) {
            projectGroup.myDisplayName = StringUtil.first((String)OptionsBundle.message((String)"configurable.group.project.named.settings.display.name", (Object[])new Object[]{project.getName()}), (int)30, (boolean)true);
        }
        this.add(40, (Configurable)projectGroup);
        SortedConfigurableGroup build = (SortedConfigurableGroup)((Object)map.remove("build"));
        if (build == null) {
            build = (SortedConfigurableGroup)((Object)map.remove("build.tools"));
        } else {
            build.add(1000, (Configurable)map.remove("build.tools"));
        }
        this.add(30, (Configurable)build);
        this.add(20, (Configurable)map.remove("language"));
        this.add(10, (Configurable)map.remove("tools"));
        this.add(-10, (Configurable)map.remove(null));
        if (1 < map.size()) {
            for (SortedConfigurableGroup group : map.values()) {
                if (this == group) continue;
                group.myDisplayName = OptionsBundle.message((String)"configurable.group.category.named.settings.display.name", (Object[])new Object[]{group.myGroupId});
                this.add(0, (Configurable)group);
            }
        }
    }

    private void add(int weight, Configurable configurable) {
        if (configurable != null) {
            this.myList.add(new WeightConfigurable(configurable, weight));
        }
    }

    protected Configurable[] buildConfigurables() {
        Collections.sort(this.myList);
        int length = this.myList.size();
        Configurable[] result = new Configurable[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myList.get(i).myConfigurable;
        }
        this.myList.clear();
        return result;
    }

    @NotNull
    public String getId() {
        String string = "configurable.group." + this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/SortedConfigurableGroup", "getId"));
        }
        return string;
    }

    @Nullable
    public String getHelpTopic() {
        return "configurable.group." + this.myGroupId + ".help.topic";
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName != null ? this.myDisplayName : OptionsBundle.message((String)("configurable.group." + this.myGroupId + ".settings.display.name"), (Object[])new Object[0]);
    }

    public String getShortName() {
        return this.getDisplayName();
    }

    private static final class WeightConfigurable
    implements Comparable<WeightConfigurable> {
        private final Configurable myConfigurable;
        private final int myWeight;

        private WeightConfigurable(@NotNull Configurable configurable, int weight) {
            if (configurable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/ex/SortedConfigurableGroup$WeightConfigurable", "<init>"));
            }
            this.myConfigurable = configurable;
            this.myWeight = weight;
        }

        @Override
        public int compareTo(@NotNull WeightConfigurable pair) {
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/openapi/options/ex/SortedConfigurableGroup$WeightConfigurable", "compareTo"));
            }
            return this.myWeight > pair.myWeight ? -1 : (this.myWeight < pair.myWeight ? 1 : StringUtil.naturalCompare((String)this.myConfigurable.getDisplayName(), (String)pair.myConfigurable.getDisplayName()));
        }
    }
}

