/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ex.SingleConfigurableEditor");
    private Project myProject;
    private Component myParentComponent;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private final String myDimensionKey;
    private final boolean myShowApplyButton;
    private boolean myChangesWereApplied;

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/options/ex/SingleConfigurableEditor", "<init>"));
        }
        super(project, true, ideModalityType);
        this.myDimensionKey = dimensionKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.myProject = project;
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey, boolean showApplyButton, DialogWrapper.IdeModalityType ideModalityType) {
        super(parent, true);
        this.myDimensionKey = dimensionServiceKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.myParentComponent = parent;
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey, boolean showApplyButton) {
        this(project, configurable, dimensionKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey, boolean showApplyButton) {
        this(parent, configurable, dimensionServiceKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/options/ex/SingleConfigurableEditor", "<init>"));
        }
        this(project, configurable, dimensionKey, true, ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey) {
        this(project, configurable, dimensionKey, true);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey) {
        this(parent, configurable, dimensionServiceKey, true);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/options/ex/SingleConfigurableEditor", "<init>"));
        }
        this(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable) {
        this(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable) {
        this(parent, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String createTitleString(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        LOG.assertTrue(displayName != null, (Object)configurable.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    protected String getDimensionServiceKey() {
        if (this.myDimensionKey == null) {
            return super.getDimensionServiceKey();
        }
        return this.myDimensionKey;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        if (this.myShowApplyButton) {
            actions.add(new ApplyAction());
        }
        if (this.myConfigurable.getHelpTopic() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/SingleConfigurableEditor", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myConfigurable.getHelpTopic());
    }

    public void doCancelAction() {
        if (this.myChangesWereApplied) {
            ApplicationManager.getApplication().saveAll();
        }
        super.doCancelAction();
    }

    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
            }
            ApplicationManager.getApplication().saveAll();
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent preferred;
        if (this.myConfigurable instanceof BaseConfigurable && (preferred = ((BaseConfigurable)this.myConfigurable).getPreferredFocusedComponent()) != null) {
            return preferred;
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
    }

    protected class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            final Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplyAction.this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent((Component)SingleConfigurableEditor.this.getWindow()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            if (SingleConfigurableEditor.this.myPerformAction) {
                return;
            }
            try {
                SingleConfigurableEditor.this.myPerformAction = true;
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.myChangesWereApplied = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog((Project)SingleConfigurableEditor.this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)SingleConfigurableEditor.this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            finally {
                SingleConfigurableEditor.this.myPerformAction = false;
            }
        }
    }
}

