/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

public class LibraryScope
extends LibraryScopeBase {
    private final Library myLibrary;

    public LibraryScope(Project project, Library library) {
        super(project, library.getFiles(OrderRootType.CLASSES), library.getFiles(OrderRootType.SOURCES));
        this.myLibrary = library;
    }

    @NotNull
    public String getDisplayName() {
        String name = this.myLibrary.getName();
        if (name == null) {
            String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
            name = urls.length > 0 ? PathUtil.getFileName((String)VfsUtilCore.urlToPath((String)urls[0])) : "empty";
        }
        String string = "Library '" + name + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/LibraryScope", "getDisplayName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.myLibrary.equals(((LibraryScope)((Object)o)).myLibrary);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myLibrary.hashCode();
    }
}

