/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ConcurrentHashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ModifierKeyDoubleClickHandler {
    private static final ModifierKeyDoubleClickHandler INSTANCE = new ModifierKeyDoubleClickHandler();
    private final ConcurrentMap<String, IdeEventQueue.EventDispatcher> myDispatchers = new ConcurrentHashMap();

    private ModifierKeyDoubleClickHandler() {
    }

    public static ModifierKeyDoubleClickHandler getInstance() {
        return INSTANCE;
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler", "registerAction"));
        }
        MyDispatcher dispatcher = new MyDispatcher(actionId, modifierKeyCode, actionKeyCode);
        IdeEventQueue.EventDispatcher oldDispatcher = this.myDispatchers.put(actionId, dispatcher);
        IdeEventQueue.getInstance().addDispatcher(dispatcher, null);
        if (oldDispatcher != null) {
            IdeEventQueue.getInstance().removeDispatcher(oldDispatcher);
        }
    }

    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler", "unregisterAction"));
        }
        IdeEventQueue.EventDispatcher oldDispatcher = (IdeEventQueue.EventDispatcher)this.myDispatchers.remove(actionId);
        if (oldDispatcher != null) {
            IdeEventQueue.getInstance().removeDispatcher(oldDispatcher);
        }
    }

    private static class MyDispatcher
    implements IdeEventQueue.EventDispatcher {
        private static final TIntIntHashMap KEY_CODE_TO_MODIFIER_MAP = new TIntIntHashMap();
        private final String myActionId;
        private final int myModifierKeyCode;
        private final int myActionKeyCode;
        private final Couple<AtomicBoolean> ourPressed;
        private final Couple<AtomicBoolean> ourReleased;
        private final AtomicBoolean ourOtherKeyWasPressed;
        private final AtomicLong ourLastTimePressed;

        public MyDispatcher(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler$MyDispatcher", "<init>"));
            }
            this.ourPressed = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourReleased = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourOtherKeyWasPressed = new AtomicBoolean(false);
            this.ourLastTimePressed = new AtomicLong(0L);
            this.myActionId = actionId;
            this.myModifierKeyCode = modifierKeyCode;
            this.myActionKeyCode = actionKeyCode;
        }

        @Override
        public boolean dispatch(AWTEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                int keyCode = keyEvent.getKeyCode();
                if (keyCode == this.myModifierKeyCode) {
                    if (this.hasOtherModifiers(keyEvent)) {
                        this.resetState();
                        return false;
                    }
                    if (this.myActionKeyCode == -1 && this.ourOtherKeyWasPressed.get() && Clock.getTime() - this.ourLastTimePressed.get() < 500L) {
                        this.resetState();
                        return false;
                    }
                    this.ourOtherKeyWasPressed.set(false);
                    if (((AtomicBoolean)this.ourPressed.first).get() && Clock.getTime() - this.ourLastTimePressed.get() > 500L) {
                        this.resetState();
                    }
                    this.handleModifier((KeyEvent)event);
                    return false;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get() && this.myActionKeyCode != -1) {
                    if (keyCode == this.myActionKeyCode) {
                        if (event.getID() == 401) {
                            this.run(keyEvent);
                        }
                        return true;
                    }
                    return false;
                }
                this.ourLastTimePressed.set(Clock.getTime());
                this.ourOtherKeyWasPressed.set(true);
                if (keyCode == 27 || keyCode == 9) {
                    this.ourLastTimePressed.set(0L);
                }
                this.resetState();
            }
            return false;
        }

        private boolean hasOtherModifiers(KeyEvent keyEvent) {
            final int modifiers = keyEvent.getModifiers();
            return !KEY_CODE_TO_MODIFIER_MAP.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int keyCode, int modifierMask) {
                    return keyCode == MyDispatcher.this.myModifierKeyCode || (modifiers & modifierMask) == 0;
                }
            });
        }

        private void handleModifier(KeyEvent event) {
            if (((AtomicBoolean)this.ourPressed.first).get() && Clock.getTime() - this.ourLastTimePressed.get() > 300L) {
                this.resetState();
                return;
            }
            if (event.getID() == 401) {
                if (!((AtomicBoolean)this.ourPressed.first).get()) {
                    this.resetState();
                    ((AtomicBoolean)this.ourPressed.first).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourPressed.second).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
            } else if (event.getID() == 402) {
                if (((AtomicBoolean)this.ourPressed.first).get() && !((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourReleased.first).set(true);
                    this.ourLastTimePressed.set(Clock.getTime());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get()) {
                    this.resetState();
                    if (this.myActionKeyCode == -1 && !this.isActionBound()) {
                        this.run(event);
                    }
                    return;
                }
            }
            this.resetState();
        }

        private void resetState() {
            ((AtomicBoolean)this.ourPressed.first).set(false);
            ((AtomicBoolean)this.ourPressed.second).set(false);
            ((AtomicBoolean)this.ourReleased.first).set(false);
            ((AtomicBoolean)this.ourReleased.second).set(false);
        }

        private void run(KeyEvent event) {
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            AnAction action = actionManager.getAction(this.myActionId);
            AnActionEvent anActionEvent = new AnActionEvent((InputEvent)event, DataManager.getInstance().getDataContext(IdeFocusManager.findInstance().getFocusOwner()), "MainMenu", action.getTemplatePresentation(), (ActionManager)actionManager, 0);
            actionManager.fireBeforeActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
            action.actionPerformed(anActionEvent);
            actionManager.fireAfterActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
        }

        private boolean isActionBound() {
            return KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.myActionId).length > 0;
        }

        static {
            KEY_CODE_TO_MODIFIER_MAP.put(18, 8);
            KEY_CODE_TO_MODIFIER_MAP.put(17, 2);
            KEY_CODE_TO_MODIFIER_MAP.put(157, 4);
            KEY_CODE_TO_MODIFIER_MAP.put(16, 1);
        }
    }
}

