/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorImpl
extends TextEditorImpl {
    private TextEditorBackgroundHighlighter myBackgroundHighlighter;

    public PsiAwareTextEditorImpl(@NotNull Project project, @NotNull VirtualFile file, TextEditorProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl", "<init>"));
        }
        super(project, file, provider);
    }

    @Override
    @NotNull
    protected TextEditorComponent createEditorComponent(Project project, VirtualFile file) {
        PsiAwareTextEditorComponent psiAwareTextEditorComponent = new PsiAwareTextEditorComponent(project, file, this);
        if (psiAwareTextEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl", "createEditorComponent"));
        }
        return psiAwareTextEditorComponent;
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new TextEditorBackgroundHighlighter(this.myProject, this.getEditor());
        }
        return this.myBackgroundHighlighter;
    }

    private static class PsiAwareTextEditorComponent
    extends TextEditorComponent {
        private final Project myProject;
        private final VirtualFile myFile;

        private PsiAwareTextEditorComponent(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextEditorImpl textEditor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent", "<init>"));
            }
            if (textEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent", "<init>"));
            }
            super(project, file, textEditor);
            this.myProject = project;
            this.myFile = file;
        }

        @Override
        void dispose() {
            CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(this.myProject);
            if (foldingManager != null) {
                foldingManager.releaseFoldings(this.getEditor());
            }
            super.dispose();
        }

        @Override
        public Object getData(String dataId) {
            LookupImpl lookup;
            if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId) && (lookup = (LookupImpl)LookupManager.getInstance(this.myProject).getActiveLookup()) != null && lookup.isVisible()) {
                return lookup.getBounds();
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                return ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
            }
            return super.getData(dataId);
        }
    }
}

