/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class WaverGraphicsDecorator
extends Graphics2D {
    public static int WAVE_ALPHA_KEY = 254;
    private final Graphics2D myOriginal;
    private final Color myWaveColor;

    public WaverGraphicsDecorator(Graphics2D original, Color waveColor) {
        this.myOriginal = original;
        this.myWaveColor = waveColor;
    }

    private void drawWave(String text, int offset, int baseline) {
        Color fore = this.getColor();
        if (fore.getAlpha() == WAVE_ALPHA_KEY) {
            int width = this.getFontMetrics().stringWidth(text);
            this.setColor(this.myWaveColor);
            int wavedAt = baseline + 1;
            for (int x = offset; x < offset + width; x += 4) {
                UIUtil.drawLine((Graphics)this, (int)x, (int)wavedAt, (int)(x + 2), (int)(wavedAt + 2));
                UIUtil.drawLine((Graphics)this, (int)(x + 3), (int)(wavedAt + 1), (int)(x + 4), (int)wavedAt);
            }
            this.setColor(fore);
        }
    }

    @Override
    public void draw(Shape s) {
        this.myOriginal.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.myOriginal.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.myOriginal.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.myOriginal.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.myOriginal.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.myOriginal.drawString(str, x, y);
        this.drawWave(str, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.myOriginal.drawString(s, x, y);
        this.drawWave(s, (int)x, (int)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.myOriginal.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.myOriginal.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.myOriginal.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.myOriginal.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.myOriginal.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.myOriginal.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.myOriginal.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.myOriginal.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.myOriginal.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.myOriginal.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.myOriginal.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.myOriginal.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.myOriginal.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.myOriginal.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.myOriginal.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.myOriginal.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.myOriginal.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.myOriginal.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.myOriginal.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.myOriginal.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.myOriginal.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.myOriginal.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.myOriginal.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.myOriginal.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.myOriginal.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.myOriginal.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.myOriginal.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.myOriginal.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.myOriginal.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.myOriginal.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new WaverGraphicsDecorator((Graphics2D)this.myOriginal.create(), this.myWaveColor);
    }

    @Override
    public Color getColor() {
        return this.myOriginal.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.myOriginal.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.myOriginal.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.myOriginal.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.myOriginal.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.myOriginal.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.myOriginal.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.myOriginal.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.myOriginal.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.myOriginal.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.myOriginal.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.myOriginal.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.myOriginal.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.myOriginal.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.myOriginal.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.myOriginal.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.myOriginal.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.myOriginal.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.myOriginal.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.myOriginal.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.myOriginal.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.myOriginal.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.myOriginal.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.myOriginal.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.myOriginal.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.myOriginal.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.myOriginal.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.myOriginal.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.myOriginal.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.myOriginal.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.myOriginal.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Rectangle getClipRect() {
        return this.myOriginal.getClipRect();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.myOriginal.hitClip(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.myOriginal.getClipBounds(r);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.myOriginal.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.myOriginal.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return new WaverGraphicsDecorator((Graphics2D)this.myOriginal.create(x, y, width, height), this.myWaveColor);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.myOriginal.drawRect(x, y, width, height);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.myOriginal.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.myOriginal.fillPolygon(p);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.myOriginal.getFontMetrics();
    }
}

