/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.ProjectScope;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    @NotNull
    public String getUniqueVirtualFilePath(Project project, VirtualFile file) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, file, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePath"));
        }
        return string;
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(Project project, VirtualFile vFile) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, vFile, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
        }
        return string;
    }

    private static String getUniqueVirtualFilePath(Project project, VirtualFile file, boolean skipNonOpenedFiles) {
        String fileName = file.getName();
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project, fileName, ProjectScope.getProjectScope((Project)project));
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile);
        }
        filesWithSameName = setOfFilesWithTheSameName;
        if (filesWithSameName.size() > 1 && filesWithSameName.contains(file)) {
            if (file instanceof VirtualFilePathWrapper) {
                return ((VirtualFilePathWrapper)file).getPresentablePath();
            }
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                builder.addPath((Object)virtualFile, virtualFile.getPath());
            }
            return UniqueVFilePathBuilderImpl.getEditorTabText(file, builder, UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS);
        }
        return file.getPresentableName();
    }

    public static <T> String getEditorTabText(T key, UniqueNameBuilder<T> builder, boolean hideKnownExtensionInTabs) {
        String withoutExtension;
        String result = builder.getShortPath(key);
        if (hideKnownExtensionInTabs && StringUtil.isNotEmpty((String)(withoutExtension = FileUtil.getNameWithoutExtension((String)result))) && !withoutExtension.endsWith(builder.getSeparator())) {
            return withoutExtension;
        }
        return result;
    }
}

