/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class HistoryEntry {
    @NonNls
    static final String TAG = "entry";
    private static final String FILE_ATTR = "file";
    @NonNls
    private static final String PROVIDER_ELEMENT = "provider";
    @NonNls
    private static final String EDITOR_TYPE_ID_ATTR = "editor-type-id";
    @NonNls
    private static final String SELECTED_ATTR_VALUE = "selected";
    @NonNls
    private static final String STATE_ELEMENT = "state";
    public final VirtualFile myFile;
    public FileEditorProvider mySelectedProvider;
    private final HashMap<FileEditorProvider, FileEditorState> myProvider2State;

    public HistoryEntry(@NotNull VirtualFile file, @NotNull FileEditorProvider[] providers, @NotNull FileEditorState[] states, @NotNull FileEditorProvider selectedProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ATTR, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (selectedProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProvider", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        this.myFile = file;
        this.myProvider2State = new HashMap();
        this.mySelectedProvider = selectedProvider;
        for (int i = 0; i < providers.length; ++i) {
            this.putState(providers[i], states[i]);
        }
    }

    public HistoryEntry(@NotNull Project project, @NotNull Element e) throws InvalidDataException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "<init>"));
        }
        this.myFile = HistoryEntry.getVirtualFile(e);
        this.myProvider2State = new HashMap();
        List providers = e.getChildren(PROVIDER_ELEMENT);
        for (Object provider1 : providers) {
            Element stateElement;
            Element _e = (Element)provider1;
            String typeId = _e.getAttributeValue(EDITOR_TYPE_ID_ATTR);
            FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(typeId);
            if (provider == null) continue;
            if (Boolean.valueOf(_e.getAttributeValue(SELECTED_ATTR_VALUE)).booleanValue()) {
                this.mySelectedProvider = provider;
            }
            if ((stateElement = _e.getChild(STATE_ELEMENT)) == null) {
                throw new InvalidDataException();
            }
            FileEditorState state2 = provider.readState(stateElement, project, this.myFile);
            this.putState(provider, state2);
        }
    }

    public FileEditorState getState(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROVIDER_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "getState"));
        }
        return (FileEditorState)this.myProvider2State.get((Object)provider);
    }

    public void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROVIDER_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STATE_ELEMENT, "com/intellij/openapi/fileEditor/impl/HistoryEntry", "putState"));
        }
        this.myProvider2State.put((Object)provider, (Object)state2);
    }

    public Element writeExternal(Element element, Project project) {
        Element e = new Element(TAG);
        element.addContent(e);
        e.setAttribute(FILE_ATTR, this.myFile.getUrl());
        for (Map.Entry entry : this.myProvider2State.entrySet()) {
            FileEditorProvider provider = (FileEditorProvider)entry.getKey();
            Element providerElement = new Element(PROVIDER_ELEMENT);
            if (provider.equals(this.mySelectedProvider)) {
                providerElement.setAttribute(SELECTED_ATTR_VALUE, Boolean.TRUE.toString());
            }
            providerElement.setAttribute(EDITOR_TYPE_ID_ATTR, provider.getEditorTypeId());
            Element stateElement = new Element(STATE_ELEMENT);
            providerElement.addContent(stateElement);
            provider.writeState((FileEditorState)entry.getValue(), project, stateElement);
            e.addContent(providerElement);
        }
        return e;
    }

    @NotNull
    public static VirtualFile getVirtualFile(Element historyElement) throws InvalidDataException {
        if (!historyElement.getName().equals(TAG)) {
            throw new IllegalArgumentException("unexpected tag: " + historyElement);
        }
        String url = historyElement.getAttributeValue(FILE_ATTR);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            throw new InvalidDataException("No file exists: " + url);
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/HistoryEntry", "getVirtualFile"));
        }
        return virtualFile;
    }
}

