/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.docking.DockManager;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePreviewPanelProvider
extends PreviewPanelProvider<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> {
    public static final PreviewProviderId<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> ID = PreviewProviderId.create("Files");
    private final FileEditorManagerImpl myManager;
    private final Project myProject;
    private EditorWindow myWindow;
    private EditorsSplitters myEditorsSplitters;

    public FilePreviewPanelProvider(@NotNull Project project, @NotNull FileEditorManagerImpl manager, @NotNull DockManager dockManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        if (dockManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockManager", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        super(ID);
        this.myProject = project;
        this.myManager = manager;
        this.myEditorsSplitters = new MyEditorsSplitters(manager, dockManager, false);
        this.myEditorsSplitters.createCurrentWindow();
        this.myWindow = this.myEditorsSplitters.getCurrentWindow();
        this.myWindow.setTabsPlacement(0);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        EditorsSplitters editorsSplitters = this.myEditorsSplitters;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getComponent"));
        }
        return editorsSplitters;
    }

    @Override
    public boolean shouldBeEnabledByDefault() {
        return true;
    }

    @Override
    protected Pair<FileEditor[], FileEditorProvider[]> initComponent(VirtualFile file, boolean requestFocus) {
        return this.myManager.openFileWithProviders(file, requestFocus, this.myWindow);
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getTitle"));
        }
        String string = StringUtil.getShortened((String)EditorTabbedContainer.calcTabTitle(this.myProject, file), (int)UISettings.getInstance().EDITOR_TAB_TITLE_LIMIT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getIcon"));
        }
        return file.getFileType().getIcon();
    }

    @Override
    public float getMenuOrder() {
        return 0.0f;
    }

    @Override
    public boolean moveContentToStandardView(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "moveContentToStandardView"));
        }
        EditorWindow window = this.myManager.getCurrentWindow();
        if (window == null) {
            this.myManager.getMainSplitters().createCurrentWindow();
            window = this.myManager.getCurrentWindow();
        }
        this.myManager.openFileWithProviders(file, true, window);
        return true;
    }

    private class MyEditorsSplitters
    extends EditorsSplitters {
        public MyEditorsSplitters(FileEditorManagerImpl manager, DockManager dockManager, boolean createOwnDockableContainer) {
            super(manager, dockManager, createOwnDockableContainer);
        }

        @Override
        protected void afterFileClosed(VirtualFile file) {
            PreviewManager previewManager = PreviewManager.SERVICE.getInstance(FilePreviewPanelProvider.this.myProject);
            if (previewManager != null) {
                previewManager.close(FilePreviewPanelProvider.this.getId(), file);
            }
        }

        @Override
        protected EditorWindow createEditorWindow() {
            return new EditorWindow(this){

                @Override
                protected void onBeforeSetEditor(VirtualFile file) {
                    ArrayList<VirtualFile> toMove = new ArrayList<VirtualFile>();
                    for (EditorWithProviderComposite composite : MyEditorsSplitters.this.getEditorsComposites()) {
                        if (!composite.isModified()) continue;
                        toMove.add(composite.getFile());
                    }
                    PreviewManager previewManager = PreviewManager.SERVICE.getInstance(FilePreviewPanelProvider.this.myProject);
                    if (previewManager != null) {
                        for (VirtualFile virtualFile : toMove) {
                            previewManager.moveToStandardPlace(FilePreviewPanelProvider.this.getId(), virtualFile);
                        }
                    }
                }
            };
        }

        @Override
        public void setTabsPlacement(int tabPlacement) {
            super.setTabsPlacement(0);
        }

        @Override
        public boolean isPreview() {
            return true;
        }
    }
}

