/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import javax.swing.Icon;

public class NewFolderAction
extends FileChooserAction {
    public NewFolderAction() {
    }

    public NewFolderAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        VirtualFile parent = fileSystemTree.getNewFileParent();
        presentation.setEnabled(parent != null && parent.isDirectory());
        this.setEnabledInModalContext(true);
    }

    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        NewFolderAction.createNewFolder(fileSystemTree);
    }

    private static void createNewFolder(FileSystemTree fileSystemTree) {
        VirtualFile file = fileSystemTree.getNewFileParent();
        if (file == null || !file.isDirectory()) {
            return;
        }
        while (true) {
            String newFolderName;
            if ((newFolderName = Messages.showInputDialog((String)UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]), (String)UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                return;
            }
            if ("".equals(newFolderName.trim())) {
                Messages.showMessageDialog((String)UIBundle.message((String)"create.new.folder.folder.name.cannot.be.empty.error.message", (Object[])new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                continue;
            }
            Exception failReason = ((FileSystemTreeImpl)fileSystemTree).createNewFolder(file, newFolderName);
            if (failReason == null) break;
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{newFolderName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }
}

