/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class GotoDesktopDirAction
extends FileChooserAction {
    @Override
    protected void actionPerformed(final FileSystemTree tree, AnActionEvent e) {
        final VirtualFile dir = GotoDesktopDirAction.getDesktopDirectory();
        if (dir != null) {
            tree.select(dir, new Runnable(){

                @Override
                public void run() {
                    tree.expand(dir, null);
                }
            });
        }
    }

    @Override
    protected void update(FileSystemTree tree, AnActionEvent e) {
        VirtualFile dir = GotoDesktopDirAction.getDesktopDirectory();
        e.getPresentation().setEnabled(dir != null && tree.isUnderRoots(dir));
    }

    @Nullable
    private static VirtualFile getDesktopDirectory() {
        File file = new File(SystemProperties.getUserHome(), "Desktop");
        return file.isDirectory() ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file) : null;
    }
}

